/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public class RegexPrincipalTransformer
implements ConfigurableElement {
    private final PathAddress address;
    private final String name;
    private final String pattern;
    private final String replacement;
    private final boolean replaceAll;

    RegexPrincipalTransformer(String name, String pattern, String replacement, boolean replaceAll) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"regex-principal-transformer", (String)name)});
        this.pattern = pattern;
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("pattern").set(this.pattern);
        addOperation.get("replacement").set(this.replacement);
        addOperation.get("replace-all").set(this.replaceAll);
        Utils.applyUpdate(addOperation, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)this.address);
        Utils.applyUpdate(removeOperation, client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String pattern;
        private String replacement;
        private boolean replaceAll;

        Builder(String name) {
            this.name = name;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public Builder replaceAll(boolean replaceAll) {
            this.replaceAll = replaceAll;
            return this;
        }

        public RegexPrincipalTransformer build() {
            return new RegexPrincipalTransformer(this.name, this.pattern, this.replacement, this.replaceAll);
        }
    }
}

