/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public class MessagingElytronDomainConfigurator
implements ConfigurableElement {
    private final String server;
    private final String elytronDomain;
    private final PathAddress messagingServerAddress;
    private String originalDomain;

    private MessagingElytronDomainConfigurator(Builder builder) {
        this.server = builder.server != null ? builder.server : "default";
        this.elytronDomain = builder.elytronDomain;
        this.messagingServerAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "messaging-activemq").append("server", this.server);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        this.originalDomain = this.setElytronDomain(client, this.elytronDomain);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        this.setElytronDomain(client, this.originalDomain);
        this.originalDomain = null;
    }

    @Override
    public String getName() {
        return "/subsystem=messaging-activemq/server=" + this.server + " elytronDomain=" + this.elytronDomain;
    }

    private String setElytronDomain(ModelControllerClient client, String domainToSet) throws Exception {
        String origDomainValue = null;
        ModelNode op = Util.createEmptyOperation((String)"read-attribute", (PathAddress)this.messagingServerAddress);
        op.get("name").set("elytron-domain");
        ModelNode result = client.execute(op);
        boolean isConfigured = Operations.isSuccessfulOutcome((ModelNode)result);
        op = null;
        if (isConfigured) {
            origDomainValue = (result = Operations.readResult((ModelNode)result)).isDefined() ? result.asString() : null;
        }
        op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)this.messagingServerAddress);
        op.get("name").set("elytron-domain");
        op.get("value").set(domainToSet);
        Utils.applyUpdate(op, client);
        return origDomainValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String server;
        private String elytronDomain;

        private Builder() {
        }

        public Builder withServer(String server) {
            this.server = server;
            return this;
        }

        public Builder withElytronDomain(String elytronDomain) {
            this.elytronDomain = elytronDomain;
            return this;
        }

        public MessagingElytronDomainConfigurator build() {
            return new MessagingElytronDomainConfigurator(this);
        }
    }
}

