/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.jboss.logging.Logger;

class NoReplayKdcServer
extends KdcServer {
    private static Logger LOGGER = Logger.getLogger(NoReplayKdcServer.class);

    NoReplayKdcServer(KerberosConfig kdcConfig) {
        super(kdcConfig);
    }

    public void start() throws IOException, LdapInvalidDnException {
        super.start();
        try {
            Field replayCacheField = KdcServer.class.getDeclaredField("replayCache");
            replayCacheField.setAccessible(true);
            replayCacheField.set((Object)this, new DummyReplayCache());
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to override replay cache.", (Throwable)e);
        }
    }

    private class DummyReplayCache
    implements ReplayCache {
        private DummyReplayCache() {
        }

        public boolean isReplay(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
            return false;
        }

        public void save(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        }

        public void clear() {
        }
    }
}

