/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.as.test.integration.security.common.Utils;

public class Krb5LoginConfiguration
extends Configuration {
    private final AppConfigurationEntry[] configList = new AppConfigurationEntry[1];
    private final String name;
    private final Configuration wrapped;

    public Krb5LoginConfiguration(Configuration wrapped) throws MalformedURLException {
        this(null, null, false, wrapped);
    }

    public Krb5LoginConfiguration(String principal, File keyTab, boolean acceptor, Configuration wrapped) throws MalformedURLException {
        String loginModule = Krb5LoginConfiguration.getLoginModule();
        Map<String, String> options = Krb5LoginConfiguration.getOptions(principal, keyTab, acceptor);
        this.configList[0] = new AppConfigurationEntry(loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        this.name = UUID.randomUUID().toString();
        this.wrapped = wrapped;
    }

    public static Map<String, String> getOptions(String principal, File keyTab, boolean acceptor) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (Utils.IBM_JDK) {
            if (keyTab != null) {
                res.put("useKeytab", keyTab.toURI().toString());
            }
            if (acceptor) {
                res.put("credsType", "acceptor");
            } else {
                res.put("noAddress", "true");
            }
        } else {
            if (keyTab != null) {
                res.put("keyTab", keyTab.getAbsolutePath());
                res.put("doNotPrompt", "true");
                res.put("useKeyTab", "true");
            }
            if (acceptor) {
                res.put("storeKey", "true");
            }
        }
        res.put("refreshKrb5Config", "true");
        if (principal != null) {
            res.put("principal", principal);
        }
        return res;
    }

    public static String getLoginModule() {
        if (Utils.IBM_JDK) {
            return "com.ibm.security.auth.module.Krb5LoginModule";
        }
        return "com.sun.security.auth.module.Krb5LoginModule";
    }

    public String getName() {
        return this.name;
    }

    protected Configuration getWrapped() {
        return this.wrapped;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        if (this.name.equals(applicationName)) {
            return this.configList;
        }
        return this.wrapped == null ? null : this.wrapped.getAppConfigurationEntry(applicationName);
    }

    public Configuration resetConfiguration() {
        Configuration.setConfiguration(this.wrapped);
        return this.wrapped;
    }
}

