/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class);

    Utils() {
    }

    static void applyUpdates(ModelControllerClient client, List<ModelNode> updates) {
        for (ModelNode update : updates) {
            try {
                Utils.applyUpdate(client, update, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void applyUpdate(ModelControllerClient client, ModelNode update, boolean allowFailure) throws IOException {
        ModelNode result = client.execute(new OperationBuilder(update).build());
        if (result.hasDefined("outcome") && (allowFailure || "success".equals(result.get("outcome").asString()))) {
            if (result.hasDefined("result")) {
                LOGGER.trace((Object)result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    static ModelNode applyRead(ModelControllerClient client, ModelNode read, boolean allowFailure) throws IOException {
        ModelNode result = client.execute(new OperationBuilder(read).build());
        if (result.hasDefined("outcome") && (allowFailure || "success".equals(result.get("outcome").asString()))) {
            return result.get("result");
        }
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
    }

    static void applyRemoveAllowReload(ModelControllerClient client, PathAddress address, boolean allowFailure) {
        ModelNode op = Util.createRemoveOperation((PathAddress)address);
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
        try {
            Utils.applyUpdate(client, op, allowFailure);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

