/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractSystemPropertiesServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractSystemPropertiesServerSetupTask.class);
    private SystemProperty[] systemProperties;

    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.trace((Object)"Adding system properties.");
        }
        this.systemProperties = this.getSystemProperties();
        if (this.systemProperties == null || this.systemProperties.length == 0) {
            LOGGER.warn((Object)"No system property configured in the ServerSetupTask");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (SystemProperty systemProperty : this.systemProperties) {
            String propertyName = systemProperty.getName();
            if (propertyName == null || propertyName.trim().length() == 0) {
                LOGGER.warn((Object)"Empty property name provided.");
                continue;
            }
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("system-property", propertyName);
            op.get("value").set(systemProperty.getValue());
            updates.add(op);
        }
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
    }

    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.trace((Object)"Removing system properties.");
        }
        if (this.systemProperties == null || this.systemProperties.length == 0) {
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (SystemProperty systemProperty : this.systemProperties) {
            String propertyName = systemProperty.getName();
            if (propertyName == null || propertyName.trim().length() == 0) continue;
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("system-property", propertyName);
            updates.add(op);
        }
        CoreUtils.applyUpdates(updates, (ModelControllerClient)managementClient.getControllerClient());
    }

    public static SystemProperty[] mapToSystemProperties(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<DefaultSystemProperty> list = new ArrayList<DefaultSystemProperty>();
        for (Map.Entry<String, String> property : map.entrySet()) {
            list.add(new DefaultSystemProperty(property.getKey(), property.getValue()));
        }
        return list.toArray(new SystemProperty[list.size()]);
    }

    protected abstract SystemProperty[] getSystemProperties();

    public static class DefaultSystemProperty
    implements SystemProperty {
        private final String name;
        private final String value;

        public DefaultSystemProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static interface SystemProperty {
        public String getName();

        public String getValue();
    }
}

