/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.shared.integration.ejb.security.CallbackHandler;
import org.jboss.as.test.shared.integration.ejb.security.Util;
import org.jboss.logging.Logger;
import org.wildfly.naming.client.WildFlyInitialContextFactory;

public final class RemoteLookups {
    private static final Logger log = Logger.getLogger(RemoteLookups.class);

    private RemoteLookups() {
    }

    public static <T> T lookupModule(InitialContext ctx, Class<T> beanType) throws NamingException {
        String lookupString = String.format("java:module/%s!%s", beanType.getSimpleName(), beanType.getName());
        log.debugf("looking for: %s", (Object)lookupString);
        return beanType.cast(ctx.lookup(lookupString));
    }

    public static <T> T lookupEjbStateless(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return RemoteLookups.lookupEjb(ctx, archiveName, beanType, remoteInterface, false);
    }

    public static <T> T lookupEjbStateful(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException {
        return RemoteLookups.lookupEjb(ctx, archiveName, beanType, remoteInterface, true);
    }

    public static <T> T lookupEjbStateless(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException, URISyntaxException {
        return RemoteLookups.lookupEjb(host, port, archiveName, beanType, remoteInterface, false);
    }

    public static <T> T lookupEjbStateful(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException, URISyntaxException {
        return RemoteLookups.lookupEjb(host, port, archiveName, beanType, remoteInterface, true);
    }

    public static <T> T lookupEjbStateless(ManagementClient managementClient, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface) throws NamingException, URISyntaxException {
        return RemoteLookups.lookupEjb(managementClient, archiveName, beanType, remoteInterface, false);
    }

    public static <T> T lookupIIOP(String serverHost, int iiopPort, Class<T> homeClass, Class<?> beanClass) throws NamingException {
        Properties prope = new Properties();
        prope.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        prope.setProperty("java.naming.factory.url.pkgs", "org.jboss.iiop.naming:org.jboss.naming.client");
        prope.put("java.naming.provider.url", "corbaloc::" + serverHost + ":" + iiopPort + "/JBoss/Naming/root");
        InitialContext context = new InitialContext(prope);
        Object ejbHome = context.lookup(beanClass.getSimpleName());
        return homeClass.cast(PortableRemoteObject.narrow((Object)ejbHome, homeClass));
    }

    private static <T> T lookupEjb(InitialContext ctx, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface, boolean isStateful) throws NamingException {
        String ejbLookup = Util.createRemoteEjbJndiContext("", archiveName, "", beanType.getSimpleName(), remoteInterface.getName(), isStateful);
        log.debugf("looking for: %s", (Object)ejbLookup);
        return remoteInterface.cast(ctx.lookup(ejbLookup));
    }

    private static <T> T lookupEjb(String host, int port, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface, boolean isStateful) throws NamingException, URISyntaxException {
        InitialContext ctx = RemoteLookups.getRemoteContext(host, port);
        return RemoteLookups.lookupEjb(ctx, archiveName, beanType, remoteInterface, isStateful);
    }

    private static <T> T lookupEjb(ManagementClient managementClient, String archiveName, Class<? extends T> beanType, Class<T> remoteInterface, boolean isStateful) throws NamingException, URISyntaxException {
        InitialContext ctx = RemoteLookups.getRemoteContext(managementClient);
        return RemoteLookups.lookupEjb(ctx, archiveName, beanType, remoteInterface, isStateful);
    }

    private static InitialContext getRemoteContext(String host, int port) throws NamingException, URISyntaxException {
        Properties props = RemoteLookups.getEjbClientProperties();
        URI namingUri = new URI("remote+http", null, host, port, "", "", "");
        props.put("java.naming.provider.url", namingUri.toString());
        return new InitialContext(props);
    }

    private static InitialContext getRemoteContext(ManagementClient managementClient) throws NamingException, URISyntaxException {
        Properties props = RemoteLookups.getEjbClientProperties();
        URI webUri = managementClient.getWebUri();
        URI namingUri = new URI("remote+http", webUri.getUserInfo(), webUri.getHost(), webUri.getPort(), "", "", "");
        props.put("java.naming.provider.url", namingUri.toString());
        return new InitialContext(props);
    }

    private static Properties getEjbClientProperties() {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", WildFlyInitialContextFactory.class.getName());
        props.put("jboss.naming.client.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT", "false");
        props.put("jboss.naming.client.security.callback.handler.class", CallbackHandler.class.getName());
        props.put("jboss.naming.client.ejb.context", (Object)true);
        return props;
    }
}

