/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class LoggingUtil {
    public static Path getLogPath(ManagementClient managementClient, String handlerType, String name) throws Exception {
        ModelNode address = Operations.createAddress((String[])new String[]{"subsystem", "logging", handlerType, name});
        ModelNode op = Operations.createOperation((String)"resolve-path", (ModelNode)address);
        ModelNode result = managementClient.getControllerClient().execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new Exception("Can't get log file");
        }
        return Paths.get(Operations.readResult((ModelNode)result).asString(), new String[0]);
    }

    public static Path getInServerLogPath(String logFile) {
        return Paths.get(System.getProperty("jboss.server.log.dir"), new String[0]).resolve(logFile);
    }

    @SafeVarargs
    public static boolean hasLogMessage(String logFileName, String logMessage, Predicate<String> ... filters) throws Exception {
        Path logPath = LoggingUtil.getInServerLogPath(logFileName);
        return LoggingUtil.isMessageInLogFile(logPath, logMessage, 0L, filters);
    }

    @SafeVarargs
    public static boolean hasLogMessage(ManagementClient managementClient, String handlerName, String logMessage, Predicate<String> ... filters) throws Exception {
        Path logPath = LoggingUtil.getLogPath(managementClient, "file-handler", handlerName);
        return LoggingUtil.isMessageInLogFile(logPath, logMessage, 0L, filters);
    }

    @SafeVarargs
    public static boolean hasLogMessage(ManagementClient managementClient, String handlerName, String logMessage, long offset, Predicate<String> ... filters) throws Exception {
        Path logPath = LoggingUtil.getLogPath(managementClient, "file-handler", handlerName);
        return LoggingUtil.isMessageInLogFile(logPath, logMessage, offset, filters);
    }

    @SafeVarargs
    private static boolean isMessageInLogFile(Path logPath, String logMessage, long offset, Predicate<String> ... filters) throws Exception {
        boolean found = false;
        try (BufferedReader fileReader = Files.newBufferedReader(logPath);){
            String line = "";
            long count = 0L;
            while ((line = fileReader.readLine()) != null) {
                if (count++ < offset || !line.contains(logMessage)) continue;
                found = true;
                for (int i = 0; found && filters != null && i < filters.length; ++i) {
                    found = filters[i].test(line);
                }
                if (!found) continue;
                break;
            }
        }
        return found;
    }

    public static void dumpTestLog(String logFileName) throws IOException {
        Path logPath = LoggingUtil.getInServerLogPath(logFileName);
        LoggingUtil.dumpTestLog(logPath);
    }

    public static void dumpTestLog(ManagementClient managementClient, String handlerName) throws Exception {
        Path logPath = LoggingUtil.getLogPath(managementClient, "file-handler", handlerName);
        LoggingUtil.dumpTestLog(logPath);
    }

    private static void dumpTestLog(Path logPath) throws IOException {
        try (BufferedReader fileReader = Files.newBufferedReader(logPath);){
            String line = "";
            while ((line = fileReader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    public static long countLines(Path logPath) throws Exception {
        try (Stream<String> lines = Files.lines(logPath);){
            long l = lines.count();
            return l;
        }
    }
}

