/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common;

import org.jboss.as.test.shared.SecureExpressionUtil;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.core.testrunner.ManagementClient;

public final class SecureExpressionUtil {
    public static void setupCredentialStoreExpressions(String storeName, SecureExpressionData ... toConfigure) throws Exception {
        org.jboss.as.test.shared.SecureExpressionUtil.setupCredentialStoreExpressions((String)storeName, (SecureExpressionUtil.SecureExpressionData[])toConfigure);
    }

    public static void setupCredentialStore(org.jboss.as.arquillian.container.ManagementClient arquillianClient, String storeName, String storeLocation) throws Exception {
        ManagementClient client = SecureExpressionUtil.getCoreManagmentClient(arquillianClient);
        org.jboss.as.test.shared.SecureExpressionUtil.setupCredentialStore((ManagementClient)client, (String)storeName, (String)storeLocation);
    }

    public static void teardownCredentialStore(org.jboss.as.arquillian.container.ManagementClient arquillianClient, String storeName, String storeLocation) throws Exception {
        ManagementClient client = SecureExpressionUtil.getCoreManagmentClient(arquillianClient);
        org.jboss.as.test.shared.SecureExpressionUtil.teardownCredentialStore((ManagementClient)client, (String)storeName, (String)storeLocation);
    }

    public static Asset getDeploymentPropertiesAsset(SecureExpressionData ... expressions) {
        StringBuilder builder = new StringBuilder("# Conversion of well known static properties to dynamic secure expressions calculated by " + SecureExpressionUtil.class.getSimpleName() + " during test setup\n");
        if (expressions != null) {
            for (SecureExpressionData expressionData : expressions) {
                if (expressionData.property == null || expressionData.property.isEmpty()) continue;
                builder.append(expressionData.property);
                builder.append('=');
                builder.append(expressionData.getExpression());
                builder.append('\n');
            }
        }
        return new StringAsset(builder.toString());
    }

    public static Class[] getDeploymentClasses() {
        return new Class[]{SecureExpressionUtil.class, SecureExpressionData.class, org.jboss.as.test.shared.SecureExpressionUtil.class, SecureExpressionUtil.SecureExpressionData.class};
    }

    private static ManagementClient getCoreManagmentClient(org.jboss.as.arquillian.container.ManagementClient arquillianClient) {
        return new ManagementClient(arquillianClient.getControllerClient(), arquillianClient.getMgmtAddress(), arquillianClient.getMgmtPort(), arquillianClient.getMgmtProtocol());
    }

    public static final class SecureExpressionData
    extends SecureExpressionUtil.SecureExpressionData {
        private final String property;

        public SecureExpressionData(String clearText, String property) {
            super(clearText);
            this.property = property;
        }
    }
}

