/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Objects;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractMechanismConfiguration;

public class MechanismRealmConfiguration
extends AbstractMechanismConfiguration {
    private final String realmName;

    private MechanismRealmConfiguration(Builder builder) {
        super(builder);
        this.realmName = Objects.requireNonNull(builder.realmName, "Realm name must not be null.");
    }

    public String getRealmName() {
        return this.realmName;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ModelNode toModelNode() {
        ModelNode node = super.toModelNode();
        ModelNodeUtil.setIfNotNull(node, "realm-name", this.realmName);
        return node;
    }

    public static final class Builder
    extends AbstractMechanismConfiguration.Builder<Builder> {
        private String realmName;

        private Builder() {
        }

        public Builder withRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public MechanismRealmConfiguration build() {
            return new MechanismRealmConfiguration(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

