/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UserWithAttributeValues {
    private final String name;
    private final String password;
    private final Set<String> values;

    private UserWithAttributeValues(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "Username must be not-null");
        this.password = builder.password != null ? builder.password : builder.name;
        this.values = new HashSet<String>(builder.values);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String password;
        private final Set<String> values = new HashSet<String>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withValues(Set<String> values) {
            if (values != null) {
                this.values.addAll(values);
            }
            return this;
        }

        public Builder withValues(String ... values) {
            if (values != null) {
                this.values.addAll(Arrays.asList(values));
            }
            return this;
        }

        public Builder clearValues() {
            this.values.clear();
            return this;
        }

        public UserWithAttributeValues build() {
            return new UserWithAttributeValues(this);
        }
    }
}

