/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.ClientLoginModule;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import org.junit.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class Util {
    public static LoginContext getCLMLoginContext(final String username, final String password) throws LoginException {
        String configurationName = "Testing";
        CallbackHandler cbh = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        ((NameCallback)current).setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"Testing".equals(name)) {
                    throw new IllegalArgumentException("Unexpected configuration name '" + name + "'");
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("multi-threaded", "true");
                options.put("restore-login-identity", "true");
                AppConfigurationEntry clmEntry = new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{clmEntry};
            }
        };
        return new LoginContext("Testing", new Subject(), cbh, config);
    }

    public static String createRemoteEjbJndiContext(String appName, String moduleName, String distinctName, String beanName, String viewClassName, boolean isStateful) {
        return "ejb:" + appName + "/" + moduleName + "/" + distinctName + "/" + beanName + "!" + viewClassName + (isStateful ? "?stateful" : "");
    }

    public static Context createNamingContext() throws NamingException {
        Properties jndiProps = new Properties();
        jndiProps.setProperty("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        return new InitialContext(jndiProps);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable) throws Exception {
        return Util.switchIdentity(username, password, callable, false, true);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable, ClassLoader classLoader) throws Exception {
        return Util.switchIdentity(username, password, callable, false, true, classLoader);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable, boolean validateException) throws Exception {
        return Util.switchIdentity(username, password, callable, validateException, true);
    }

    public static <T> T switchIdentity(String username, String password, Callable<T> callable, boolean validateException, boolean useClientLoginModule) throws Exception {
        return Util.switchIdentity(username, password, callable, validateException, useClientLoginModule, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T switchIdentity(String username, String password, Callable<T> callable, boolean validateException, boolean useClientLoginModule, ClassLoader classLoader) throws Exception {
        boolean initialAuthSucceeded = false;
        try {
            SecurityDomain securityDomain;
            if (username == null) return callable.call();
            if (password == null) return callable.call();
            if (classLoader != null) {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    securityDomain = SecurityDomain.getCurrent();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            } else {
                securityDomain = SecurityDomain.getCurrent();
            }
            if (securityDomain != null) {
                SecurityIdentity securityIdentity = securityDomain.authenticate(username, (Evidence)new PasswordGuessEvidence(password.toCharArray()));
                return (T)securityIdentity.runAs(callable);
            }
            if (useClientLoginModule) {
                LoginContext lc = Util.getCLMLoginContext(username, password);
                lc.login();
                try {
                    T t = callable.call();
                    return t;
                }
                finally {
                    lc.logout();
                }
            }
            SecurityClient client = SecurityClientFactory.getSecurityClient();
            client.setSimple((Object)username, (Object)password);
            client.login();
            try {
                T t = callable.call();
                return t;
            }
            finally {
                client.logout();
            }
        }
        catch (Exception e) {
            if (!validateException) throw e;
            Util.validateException(e, initialAuthSucceeded);
            return null;
        }
    }

    private static void validateException(Exception e, boolean initialAuthSucceeded) {
        if (SecurityDomain.getCurrent() != null) {
            if (initialAuthSucceeded) {
                Assert.assertTrue((String)"Expected EJBException due to bad password not thrown.", (e instanceof EJBException && e.getCause() instanceof SecurityException ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)"Expected SecurityException due to bad password not thrown.", (boolean)(e instanceof SecurityException));
            }
        } else {
            Assert.assertTrue((String)"Expected EJBAccessException due to bad password not thrown. (EJB 3.1 FR 17.6.9)", (boolean)(e instanceof EJBAccessException));
        }
    }

    public static <T> T switchIdentitySCF(String username, String password, Callable<T> callable) throws Exception {
        return Util.switchIdentity(username, password, callable, false, false);
    }
}

