/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.CertificateRevocationList;
import org.wildfly.test.security.common.elytron.Ocsp;
import org.wildfly.test.security.common.elytron.TrustManager;

public class SimpleTrustManager
extends AbstractConfigurableElement
implements TrustManager {
    private final String keyStore;
    private final String algorithm;
    private final int maximumCertPath;
    private final Boolean onlyLeafCert;
    private final Boolean softFail;
    private final Ocsp ocsp;
    private final CertificateRevocationList crl;
    private final List<CertificateRevocationList> crls;

    private SimpleTrustManager(Builder builder) {
        super(builder);
        this.keyStore = Objects.requireNonNull(builder.keyStore, "Key-store name has to be provided");
        this.algorithm = builder.algorithm;
        this.maximumCertPath = builder.maximumCertPath;
        this.softFail = builder.softFail;
        this.onlyLeafCert = builder.onlyLeafCert;
        this.ocsp = builder.ocsp;
        this.crl = builder.crl;
        this.crls = builder.crls;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder cliLine = new StringBuilder("/subsystem=elytron/trust-manager=").append(this.name).append(":add(");
        if (this.ocsp != null) {
            cliLine.append(this.ocsp.asString());
        }
        if (this.crl != null) {
            cliLine.append("certificate-revocation-list=");
            cliLine.append(this.crl.asString());
            cliLine.append(", ");
        } else if (this.crls != null) {
            cliLine.append("certificate-revocation-lists=[");
            for (int i = 0; i < this.crls.size(); ++i) {
                cliLine.append(this.crls.get(i).asString());
                if (i == this.crls.size() - 1) continue;
                cliLine.append(", ");
            }
            cliLine.append("], ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStore)) {
            cliLine.append("key-store=\"").append(this.keyStore).append("\"");
        }
        String alg = StringUtils.isNotBlank((CharSequence)this.algorithm) ? this.algorithm : (SystemUtils.JAVA_VENDOR.toUpperCase(Locale.ENGLISH).contains("IBM") ? "IBMX509" : "SunX509");
        cliLine.append(",algorithm=\"").append(alg).append("\"");
        if (this.softFail != null) {
            cliLine.append(",soft-fail=\"").append(this.softFail).append("\"");
        }
        if (this.onlyLeafCert != null) {
            cliLine.append(",only-leaf-cert=\"").append(this.onlyLeafCert).append("\"");
        }
        if (this.maximumCertPath > -1) {
            cliLine.append(",maximum-cert-path=\"").append(this.maximumCertPath).append("\"");
        }
        cliLine.append(")");
        cli.sendLine(cliLine.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/trust-manager=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String keyStore;
        private String algorithm;
        private int maximumCertPath = -1;
        private Boolean onlyLeafCert;
        private Boolean softFail;
        private Ocsp ocsp;
        private CertificateRevocationList crl;
        private List<CertificateRevocationList> crls;

        private Builder() {
        }

        public Builder withKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder withAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder withMaximumCertPath(int maximumCertPath) {
            this.maximumCertPath = maximumCertPath;
            return this;
        }

        public Builder withOnlyLeafCert(boolean onlyLeafCert) {
            this.onlyLeafCert = onlyLeafCert;
            return this;
        }

        public Builder withSoftFail(boolean softFail) {
            this.softFail = softFail;
            return this;
        }

        public Builder withOcsp(Ocsp ocsp) {
            this.ocsp = ocsp;
            return this;
        }

        public Builder withCrl(CertificateRevocationList crl) {
            this.crl = crl;
            return this;
        }

        public Builder withCrls(List<CertificateRevocationList> crls) {
            this.crls = crls;
            return this;
        }

        public SimpleTrustManager build() {
            return new SimpleTrustManager(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

