/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.test.integration.management.util.CLITestUtil;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class CLIServerSetupTask
implements ServerSetupTask {
    private static final Logger LOG = Logger.getLogger(CLIServerSetupTask.class);
    protected final Builder builder = new Builder();

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        NodeBuilder node = this.builder.configuration.get(containerId);
        if (node != null && !node.setupCommands.isEmpty()) {
            this.executeCommands(managementClient, node.setupCommands, node.batch, node.reloadOnSetup);
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        NodeBuilder node = this.builder.configuration.get(containerId);
        if (node != null && !node.teardownCommands.isEmpty()) {
            this.executeCommands(managementClient, node.teardownCommands, node.batch, node.reloadOnTearDown);
        }
    }

    private void executeCommands(ManagementClient managementClient, List<String> commands, boolean useBatch, boolean reload) throws Exception {
        if (commands.isEmpty()) {
            return;
        }
        CommandContext context = CLITestUtil.getCommandContext();
        context.connectController();
        if (useBatch) {
            context.getBatchManager().activateNewBatch();
            Batch batch = context.getBatchManager().getActiveBatch();
            for (String command : commands) {
                batch.add(context.toBatchedCommand(command));
            }
            ModelNode commandModel = batch.toRequest();
            ModelNode result = managementClient.getControllerClient().execute(commandModel);
            LOG.debugf("Executed batch %s with result %s", commands, (Object)result.toJSONString(true));
            this.checkResult(result);
        } else {
            for (String command : commands) {
                ModelNode commandModel = context.buildRequest(command);
                ModelNode result = managementClient.getControllerClient().execute(commandModel);
                LOG.debugf("Executed single command %s with result %s", commands, (Object)result.toJSONString(true));
                this.checkResult(result);
            }
        }
        if (reload) {
            LOG.debugf("Reloading server %s if its in a 'reload-required' state.", (Object)managementClient.getMgmtAddress());
            ServerReload.reloadIfRequired(managementClient);
        }
    }

    private void checkResult(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            String failureDesc = result.get("failure-description").toString();
            throw new RuntimeException("CLIServerSetupTask failed! Failed with: " + failureDesc);
        }
    }

    public static class NodeBuilder {
        private final Builder parentBuilder;
        private final List<String> setupCommands = new LinkedList<String>();
        private final List<String> teardownCommands = new LinkedList<String>();
        private boolean batch = true;
        private boolean reloadOnSetup = true;
        private boolean reloadOnTearDown = true;

        NodeBuilder(Builder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public NodeBuilder setup(String setupCommand) {
            this.setupCommands.add(setupCommand);
            return this;
        }

        public NodeBuilder setup(String formatSetupCommand, Object ... formatArguments) {
            return this.setup(String.format(formatSetupCommand, formatArguments));
        }

        public NodeBuilder teardown(String teardownCommand) {
            this.teardownCommands.add(teardownCommand);
            return this;
        }

        public NodeBuilder teardown(String formatTeardownCommand, Object ... formatArguments) {
            return this.teardown(String.format(formatTeardownCommand, formatArguments));
        }

        public NodeBuilder batch(boolean batch) {
            this.batch = batch;
            return this;
        }

        public NodeBuilder reloadOnSetup(boolean reloadOnSetup) {
            this.reloadOnSetup = reloadOnSetup;
            return this;
        }

        public NodeBuilder reloadOnTearDown(boolean reloadOnTearDown) {
            this.reloadOnTearDown = reloadOnTearDown;
            return this;
        }

        public Builder parent() {
            return this.parentBuilder;
        }
    }

    public static class Builder {
        private final Map<String, NodeBuilder> configuration = new HashMap<String, NodeBuilder>();

        public NodeBuilder node(String node) {
            if (this.configuration.containsKey(node)) {
                return this.configuration.get(node);
            }
            NodeBuilder nodeBuilder = new NodeBuilder(this);
            this.configuration.put(node, nodeBuilder);
            return nodeBuilder;
        }

        public NodeBuilder node(String ... nodes) {
            if (Stream.of(nodes).anyMatch(this.configuration::containsKey)) {
                throw new IllegalStateException("Node-specific overrides need to be done for per node.");
            }
            NodeBuilder nodeBuilder = new NodeBuilder(this);
            Stream.of(nodes).forEach(n -> this.configuration.put((String)n, nodeBuilder));
            return nodeBuilder;
        }
    }
}

