/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.logging.syslogserver;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.logging.Logger;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;

public class Rfc5424SyslogEvent
implements SyslogServerEventIF {
    private static final char SP = ' ';
    private static final String CHARSET = "UTF-8";
    private static final String NIL = "-";
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static Logger LOGGER = Logger.getLogger(Rfc5424SyslogEvent.class);
    private final byte[] raw;
    private final String prioVersion;
    private final int facility;
    private final int level;
    private final int version;
    private final String timestamp;
    private final String host;
    private final String appName;
    private final String procId;
    private final String msgId;
    private final String structuredData;
    private final String message;

    public Rfc5424SyslogEvent(byte[] data, int offset, int length) {
        this.raw = new byte[length - offset];
        System.arraycopy(data, offset, this.raw, 0, length);
        int startPos = 0;
        int endPos = -1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.prioVersion = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.timestamp = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.host = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.appName = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.procId = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        endPos = this.searchChar(this.raw, startPos, ' ');
        this.msgId = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        if (this.raw[startPos] == 91) {
            endPos = this.searchChar(this.raw, startPos, ']') + 1;
        } else {
            endPos = this.searchChar(this.raw, startPos, ' ');
            if (endPos == -1) {
                endPos = this.raw.length;
            }
        }
        this.structuredData = this.getString(this.raw, startPos, endPos);
        startPos = endPos + 1;
        if (startPos < this.raw.length) {
            if (startPos + 3 < this.raw.length && this.raw[startPos] == UTF_8_BOM[0] && this.raw[startPos + 1] == UTF_8_BOM[1] && this.raw[startPos + 2] == UTF_8_BOM[2]) {
                startPos += 3;
            }
            this.message = this.getString(this.raw, startPos, this.raw.length);
        } else {
            this.message = null;
        }
        endPos = this.prioVersion.indexOf(">");
        String priorityStr = this.prioVersion.substring(1, endPos);
        int priority = 0;
        try {
            priority = Integer.parseInt(priorityStr);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error((Object)"Can't parse priority");
        }
        this.level = priority & 7;
        this.facility = priority - this.level >> 3;
        startPos = endPos + 1;
        int ver = 0;
        if (startPos < this.prioVersion.length()) {
            try {
                ver = Integer.parseInt(this.prioVersion.substring(startPos));
            }
            catch (NumberFormatException nfe) {
                LOGGER.error((Object)"Can't parse version");
                ver = -1;
            }
        }
        this.version = ver;
    }

    private String getString(byte[] data, int startPos, int endPos) {
        try {
            return new String(data, startPos, endPos - startPos, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Unsupported encoding", (Throwable)e);
            return "";
        }
    }

    private int searchChar(byte[] data, int startPos, char c) {
        for (int i = startPos; i < data.length; ++i) {
            if (data[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String getPrioVersion() {
        return this.prioVersion;
    }

    public int getFacility() {
        return this.facility;
    }

    public int getLevel() {
        return this.level;
    }

    public int getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getHost() {
        return this.host;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProcId() {
        return this.procId;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getStructuredData() {
        return this.structuredData;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCharSet() {
        return CHARSET;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public Date getDate() {
        if (NIL.equals(this.timestamp)) {
            return null;
        }
        Object fixTz = this.timestamp.replace("Z", "+00:00");
        int tzSeparatorPos = ((String)fixTz).lastIndexOf(":");
        fixTz = ((String)fixTz).substring(0, tzSeparatorPos) + ((String)fixTz).substring(tzSeparatorPos + 1);
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ").parse((String)fixTz);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Unable to parse date " + this.timestamp), (Throwable)e);
            return null;
        }
    }

    public void setCharSet(String charSet) {
    }

    public void setFacility(int facility) {
    }

    public void setDate(Date date) {
    }

    public void setLevel(int level) {
    }

    public void setHost(String host) {
    }

    public void setMessage(String message) {
    }

    public String toString() {
        return "Rfc5424SyslogEvent [prioVersion=" + this.prioVersion + ", facility=" + this.facility + ", level=" + this.level + ", version=" + this.version + ", timestamp=" + this.timestamp + ", host=" + this.host + ", appName=" + this.appName + ", procId=" + this.procId + ", msgId=" + this.msgId + ", structuredData=" + this.structuredData + ", message=" + this.message + "]";
    }
}

