/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.microprofile.jwt;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.UUID;

public class TokenUtil {
    private static PrivateKey loadPrivateKey(String fileName) throws Exception {
        try (FileInputStream is = new FileInputStream(fileName);){
            byte[] contents = new byte[4096];
            int length = ((InputStream)is).read(contents);
            String rawKey = new String(contents, 0, length, StandardCharsets.UTF_8).replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)----", "").replaceAll("\r\n", "").replaceAll("\n", "").trim();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(rawKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
    }

    public static String generateJWT(String keyLocation, String principal, String birthdate, String ... groups) throws Exception {
        PrivateKey privateKey = TokenUtil.loadPrivateKey(keyLocation);
        RSASSASigner signer = new RSASSASigner(privateKey);
        JsonArrayBuilder groupsBuilder = Json.createArrayBuilder();
        for (String group : groups) {
            groupsBuilder.add(group);
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        JsonObjectBuilder claimsBuilder = Json.createObjectBuilder().add("sub", principal).add("upn", principal).add("iss", "quickstart-jwt-issuer").add("aud", "jwt-audience").add("groups", (JsonValue)groupsBuilder.build()).add("birthdate", birthdate).add("jti", UUID.randomUUID().toString()).add("iat", currentTime).add("exp", currentTime + 14400L);
        JWSObject jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.RS256).type(new JOSEObjectType("jwt")).keyID("Test Key").build(), new Payload(claimsBuilder.build().toString()));
        jwsObject.sign((JWSSigner)signer);
        return jwsObject.serialize();
    }
}

