/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.SecurityRealm;

public class FailoverRealm
implements SecurityRealm {
    private final PathAddress address;
    private final String name;
    private final String delegateRealm;
    private final String failoverRealm;
    private final Boolean emitEvents;

    FailoverRealm(String name, Builder builder) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"failover-realm", (String)name)});
        this.delegateRealm = builder.delegateRealm;
        this.failoverRealm = builder.failoverRealm;
        this.emitEvents = builder.emitEvents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModelNode getAddOperation() {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        if (this.delegateRealm != null) {
            addOperation.get("delegate-realm").set(this.delegateRealm);
        }
        if (this.failoverRealm != null) {
            addOperation.get("failover-realm").set(this.failoverRealm);
        }
        if (this.emitEvents != null) {
            addOperation.get("emit-events").set(this.emitEvents.booleanValue());
        }
        return addOperation;
    }

    public ModelNode getRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)this.address);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getAddOperation(), client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getRemoveOperation(), client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String delegateRealm;
        private String failoverRealm;
        private Boolean emitEvents;

        Builder(String name) {
            this.name = name;
        }

        public Builder withDelegateRealm(String realm) {
            this.delegateRealm = realm;
            return this;
        }

        public Builder withFailoverRealm(String realm) {
            this.failoverRealm = realm;
            return this;
        }

        public Builder withEmitEvents(Boolean emitEvents) {
            this.emitEvents = emitEvents;
            return this;
        }

        public SecurityRealm build() {
            return new FailoverRealm(this.name, this);
        }
    }
}

