/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.Utils;

public class ElytronDomainSetup
implements ServerSetupTask {
    private static final String SUBSYSTEM_NAME = "elytron";
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "elytron-tests";
    private static final String DEFAULT_PERMISSION_MAPPER_NAME = "default-permission-mapper";
    private PathAddress realmAddress;
    private PathAddress domainAddress;
    private PathAddress permissionMapperAddress;
    private PathAddress roleDecoder1Address;
    private PathAddress roleDecoder2Address;
    private PathAddress aggregateRoleDecoderAddress;
    private final String usersFile;
    private final String groupsFile;
    private final String securityDomainName;
    private final String permissionMapperName;
    private final String ipAddress;

    public ElytronDomainSetup(String usersFile, String groupsFile) {
        this(usersFile, groupsFile, DEFAULT_SECURITY_DOMAIN_NAME, DEFAULT_PERMISSION_MAPPER_NAME, null);
    }

    public ElytronDomainSetup(String usersFile, String groupsFile, String securityDomainName) {
        this(usersFile, groupsFile, securityDomainName, DEFAULT_PERMISSION_MAPPER_NAME, null);
    }

    public ElytronDomainSetup(String usersFile, String groupsFile, String securityDomainName, String permissionMapperName, String ipAddress) {
        this.usersFile = usersFile;
        this.groupsFile = groupsFile;
        this.securityDomainName = securityDomainName;
        this.permissionMapperName = permissionMapperName;
        this.ipAddress = ipAddress;
    }

    protected String getSecurityDomainName() {
        return this.securityDomainName;
    }

    protected String getSecurityRealmName() {
        return this.getSecurityDomainName() + "-ejb3-UsersRoles";
    }

    protected String getUndertowDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getEjbDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getSaslAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getRemotingConnectorName() {
        return "http-remoting-connector";
    }

    protected String getHttpAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getUsersFile() {
        return this.usersFile;
    }

    protected String getGroupsFile() {
        return this.groupsFile;
    }

    protected String getPermissionMapperName() {
        return this.permissionMapperName;
    }

    protected boolean isUsersFilePlain() {
        return true;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.realmAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("properties-realm", this.getSecurityRealmName());
        this.domainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("security-domain", this.getSecurityDomainName());
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        ModelNode addRealm = Util.createAddOperation((PathAddress)this.realmAddress);
        addRealm.get("users-properties").get("path").set(this.getUsersFile());
        addRealm.get("users-properties").get("plain-text").set(this.isUsersFilePlain());
        addRealm.get("groups-properties").get("path").set(this.getGroupsFile());
        steps.add(addRealm);
        if (!this.permissionMapperName.equals(DEFAULT_PERMISSION_MAPPER_NAME)) {
            this.permissionMapperAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("simple-permission-mapper", this.permissionMapperName);
            ModelNode addPermissionMapper = Util.createAddOperation((PathAddress)this.permissionMapperAddress);
            ModelNode permissionMapping1 = new ModelNode();
            permissionMapping1.get("roles").add("Admin");
            ModelNode permissionSet = new ModelNode();
            permissionSet.get("permission-set").set("login-permission");
            permissionMapping1.get("permission-sets").add(permissionSet);
            addPermissionMapper.get("permission-mappings").add(permissionMapping1);
            ModelNode permissionMapping2 = new ModelNode();
            permissionMapping2.get("principals").add("user2");
            addPermissionMapper.get("permission-mappings").add(permissionMapping2);
            addPermissionMapper.get("mapping-mode").set("and");
            steps.add(addPermissionMapper);
            this.roleDecoder1Address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("source-address-role-decoder", "decoder1");
            ModelNode addRoleDecoder1 = Util.createAddOperation((PathAddress)this.roleDecoder1Address);
            addRoleDecoder1.get("source-address").set(this.ipAddress);
            addRoleDecoder1.get("roles").add("Admin");
            steps.add(addRoleDecoder1);
            this.roleDecoder2Address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("source-address-role-decoder", "decoder2");
            ModelNode addRoleDecoder2 = Util.createAddOperation((PathAddress)this.roleDecoder2Address);
            addRoleDecoder2.get("source-address").set("99.99.99.99");
            addRoleDecoder2.get("roles").add("Employee");
            steps.add(addRoleDecoder2);
            this.aggregateRoleDecoderAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", SUBSYSTEM_NAME).append("aggregate-role-decoder", "aggregateRoleDecoder");
            ModelNode addAggregateRoleDecoder = Util.createAddOperation((PathAddress)this.aggregateRoleDecoderAddress);
            addAggregateRoleDecoder.get("role-decoders").add("decoder1");
            addAggregateRoleDecoder.get("role-decoders").add("decoder2");
            steps.add(addAggregateRoleDecoder);
        }
        ModelNode addDomain = Util.createAddOperation((PathAddress)this.domainAddress);
        addDomain.get("permission-mapper").set(this.permissionMapperName);
        if (!this.permissionMapperName.equals(DEFAULT_PERMISSION_MAPPER_NAME)) {
            addDomain.get("role-decoder").set("aggregateRoleDecoder");
        }
        addDomain.get("default-realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("role-decoder").set("groups-to-roles");
        addDomain.get("realms").get(1).get("realm").set("local");
        steps.add(addDomain);
        Utils.applyUpdate(managementClient.getControllerClient(), compositeOp, false);
    }

    public void tearDown(ManagementClient managementClient, String containerId) {
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.domainAddress, false);
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.realmAddress, false);
        if (!this.permissionMapperName.equals(DEFAULT_PERMISSION_MAPPER_NAME)) {
            Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.permissionMapperAddress, false);
            Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.aggregateRoleDecoderAddress, false);
            Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.roleDecoder1Address, false);
            Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.roleDecoder2Address, false);
        }
    }
}

