/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.jca;

import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.as.test.integration.management.jca.ConnectionSecurityType;
import org.jboss.dmr.ModelNode;

public class ComplexPropertiesParseUtils {
    public static Properties commonDsProperties(String jndiName, ConnectionSecurityType connectionSecurityType) {
        Properties params = new Properties();
        params.put("use-java-context", "true");
        params.put("spy", "false");
        params.put("use-ccm", "true");
        params.put("jndi-name", jndiName);
        params.put("driver-name", "h2");
        params.put("new-connection-sql", "select 1");
        params.put("transaction-isolation", "TRANSACTION_READ_COMMITTED");
        params.put("url-delimiter", ":");
        params.put("url-selector-strategy-class-name", "someClass");
        params.put("min-pool-size", "1");
        params.put("max-pool-size", "5");
        params.put("pool-prefill", "true");
        params.put("pool-use-strict-min", "true");
        params.put("flush-strategy", "EntirePool");
        switch (connectionSecurityType) {
            case ELYTRON_AUTHENTICATION_CONTEXT: {
                params.put("authentication-context", "HsqlAuthCtxt");
            }
            case ELYTRON: {
                params.put("elytron-enabled", "true");
                break;
            }
            case SECURITY_DOMAIN: {
                params.put("security-domain", "HsqlDbRealm");
                break;
            }
            case USER_PASSWORD: {
                params.put("user-name", "sa");
                params.put("password", "sa");
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported security connection type for data sources: " + connectionSecurityType);
            }
        }
        params.put("reauth-plugin-class-name", "someClass1");
        params.put("valid-connection-checker-class-name", "someClass2");
        params.put("check-valid-connection-sql", "select 1");
        params.put("validate-on-match", "true");
        params.put("background-validation", "true");
        params.put("background-validation-millis", "2000");
        params.put("use-fast-fail", "true");
        params.put("stale-connection-checker-class-name", "someClass3");
        params.put("exception-sorter-class-name", "someClass4");
        params.put("blocking-timeout-wait-millis", "20000");
        params.put("idle-timeout-minutes", "4");
        params.put("set-tx-query-timeout", "true");
        params.put("query-timeout", "120");
        params.put("use-try-lock", "100");
        params.put("allocation-retry", "2");
        params.put("allocation-retry-wait-millis", "3000");
        params.put("track-statements", "nowarn");
        params.put("prepared-statements-cache-size", "30");
        params.put("share-prepared-statements", "true");
        return params;
    }

    public static Properties xaDsProperties(String jndiName, ConnectionSecurityType connectionSecurityType) {
        Properties params = ComplexPropertiesParseUtils.commonDsProperties(jndiName, connectionSecurityType);
        params.put("xa-datasource-class", "org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource");
        params.put("same-rm-override", "true");
        params.put("interleaving", "true");
        params.put("no-tx-separate-pool", "true");
        params.put("pad-xid", "true");
        params.put("wrap-xa-resource", "true");
        params.put("xa-resource-timeout", "120");
        params.put("no-recovery", "false");
        params.put("recovery-plugin-class-name", "someClass5");
        switch (connectionSecurityType) {
            case ELYTRON_AUTHENTICATION_CONTEXT: {
                params.put("recovery-authentication-context", "HsqlAuthCtxt");
            }
            case ELYTRON: {
                params.put("recovery-elytron-enabled", "true");
                break;
            }
            case SECURITY_DOMAIN: {
                params.put("recovery-security-domain", "HsqlDbRealm");
                break;
            }
            case USER_PASSWORD: {
                params.put("recovery-username", "sa");
                params.put("recovery-password", "sa");
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported connection security for data sources: " + connectionSecurityType);
            }
        }
        return params;
    }

    public static Properties nonXaDsProperties(String jndiName, ConnectionSecurityType connectionSecurityType) {
        Properties params = ComplexPropertiesParseUtils.commonDsProperties(jndiName, connectionSecurityType);
        params.put("jta", "false");
        params.put("driver-class", "org.hsqldb.jdbcDriver");
        params.put("datasource-class", "org.jboss.as.connector.subsystems.datasources.ModifiableDataSource");
        params.put("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE");
        return params;
    }

    public static Properties raCommonProperties() {
        Properties params = new Properties();
        params.put("archive", "some.rar");
        params.put("transaction-support", "XATransaction");
        params.put("bootstrap-context", "default");
        return params;
    }

    public static Properties raConnectionProperties(ConnectionSecurityType connectionSecurityType, ConnectionSecurityType recoverySecurityType) {
        Properties params = new Properties();
        params.put("use-java-context", "false");
        params.put("class-name", "Class1");
        params.put("use-ccm", "true");
        params.put("jndi-name", "java:jboss/name1");
        params.put("enabled", "false");
        params.put("min-pool-size", "1");
        params.put("max-pool-size", "5");
        params.put("pool-prefill", "true");
        params.put("pool-use-strict-min", "true");
        params.put("flush-strategy", "IdleConnections");
        params.put("same-rm-override", "true");
        params.put("interleaving", "true");
        params.put("no-tx-separate-pool", "true");
        params.put("pad-xid", "true");
        params.put("wrap-xa-resource", "true");
        switch (connectionSecurityType) {
            case APPLICATION: {
                params.put("security-application", "true");
                break;
            }
            case SECURITY_DOMAIN: {
                params.put("security-domain", "SecRealm");
                break;
            }
            case SECURITY_DOMAIN_AND_APPLICATION: {
                params.put("security-domain-and-application", "SecAndAppRealm");
                break;
            }
            case ELYTRON: {
                params.put("elytron-enabled", "true");
                break;
            }
            case ELYTRON_AUTHENTICATION_CONTEXT: {
                params.put("elytron-enabled", "true");
                params.put("authentication-context", "AuthCtxt");
                break;
            }
            case ELYTRON_AUTHENTICATION_CONTEXT_AND_APPLICATION: {
                params.put("elytron-enabled", "true");
                params.put("authentication-context-and-application", "AuthCtxtAndApp");
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported connection security type for rars: " + connectionSecurityType);
            }
        }
        params.put("background-validation", "true");
        params.put("background-validation-millis", "5000");
        params.put("use-fast-fail", "true");
        params.put("blocking-timeout-wait-millis", "5000");
        params.put("idle-timeout-minutes", "4");
        params.put("allocation-retry", "2");
        params.put("allocation-retry-wait-millis", "3000");
        params.put("xa-resource-timeout", "300");
        params.put("no-recovery", "false");
        params.put("recovery-plugin-class-name", "someClass2");
        if (recoverySecurityType != null) {
            switch (recoverySecurityType) {
                case USER_PASSWORD: {
                    params.put("recovery-username", "sa");
                    params.put("recovery-password", "sa-pass");
                    break;
                }
                case SECURITY_DOMAIN: {
                    params.put("recovery-security-domain", "SecRealm");
                    break;
                }
                case ELYTRON: {
                    params.put("recovery-elytron-enabled", "true");
                    break;
                }
                case ELYTRON_AUTHENTICATION_CONTEXT: {
                    params.put("recovery-elytron-enabled", "true");
                    params.put("recovery-authentication-context", "AuthCtxt");
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported connection recovery security type for rars: " + connectionSecurityType);
                }
            }
        }
        return params;
    }

    public static Properties raAdminProperties() {
        Properties params = new Properties();
        params.put("use-java-context", "true");
        params.put("class-name", "Class3");
        params.put("jndi-name", "java:jboss/Name3");
        params.put("enabled", "true");
        return params;
    }

    public static void setOperationParams(ModelNode operation, Properties params) {
        Enumeration<?> e = params.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            operation.get(str).set(params.getProperty(str));
        }
    }

    public static void addExtensionProperties(ModelNode operation) {
        operation.get(new String[]{"reauth-plugin-properties", "name"}).set("Property1");
        operation.get(new String[]{"valid-connection-checker-properties", "name"}).set("Property2");
        operation.get(new String[]{"stale-connection-checker-properties", "name"}).set("Property3");
        operation.get(new String[]{"exception-sorter-properties", "name"}).set("Property4");
    }

    public static boolean checkModelParams(ModelNode node, Properties params) {
        if (node == null) {
            return false;
        }
        Enumeration<?> e = params.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            String par = params.getProperty(str);
            if (node.get(str) == null) {
                return false;
            }
            if (node.get(str).asString().equals(par)) continue;
            return false;
        }
        return true;
    }
}

