/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@WebServlet(value={"/DataSourceTestServlet"})
public class DataSourceTestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/DataSourceTestServlet";
    public static final String PARAM_DS = "datasource";
    public static final String PARAM_DS_DEFAULT = "ExampleDS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        String datasourceName = req.getParameter(PARAM_DS);
        if (datasourceName == null || datasourceName.length() == 0) {
            datasourceName = PARAM_DS_DEFAULT;
        }
        PrintWriter writer = resp.getWriter();
        Connection con = null;
        try {
            InitialContext iniCtx = new InitialContext();
            DataSource ds = (DataSource)iniCtx.lookup("java:jboss/datasources/" + datasourceName);
            con = ds.getConnection();
            Statement stmt = con.createStatement();
            stmt.executeUpdate("create table testtable(testid int)");
            stmt.executeUpdate("insert into testtable values (1)");
            ResultSet rs = stmt.executeQuery("select * from testtable");
            writer.print(rs.next() && 1 == rs.getInt(1));
            rs.close();
            stmt.executeUpdate("drop table testtable");
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace(writer);
        }
        catch (NamingException e) {
            e.printStackTrace(writer);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

