/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.test.integration.management.util.CLITestUtil;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.dmr.ModelNode;

public class ManagementServerSetupTask
implements ServerSetupTask {
    private final ContainerSetConfiguration config;

    public static ContainerSetConfigurationBuilder createContainerSetConfigurationBuilder() {
        return new ContainerSetConfigurationBuilder(){
            private final Map<String, ContainerConfiguration> containers = new HashMap<String, ContainerConfiguration>();
            private ContainerConfiguration defaultContainer = null;

            @Override
            public ContainerSetConfigurationBuilder addContainers(Set<String> containers, ContainerConfiguration configuration) {
                for (String container : containers) {
                    this.containers.put(container, configuration);
                }
                return this;
            }

            @Override
            public ContainerSetConfigurationBuilder defaultContainer(ContainerConfiguration configuration) {
                this.defaultContainer = configuration;
                return this;
            }

            @Override
            public ContainerSetConfiguration build() {
                final Map<String, ContainerConfiguration> containers = this.containers;
                final ContainerConfiguration defaultConfig = this.defaultContainer;
                return new ContainerSetConfiguration(){

                    @Override
                    public ContainerConfiguration getContainerConfiguration(String container) {
                        return containers.getOrDefault(container, defaultConfig);
                    }
                };
            }
        };
    }

    public static ContainerConfigurationBuilder createContainerConfigurationBuilder() {
        return new ContainerConfigurationBuilder(){
            private List<List<String>> setupScript = List.of();
            private List<List<String>> tearDownScript = List.of();

            @Override
            public ContainerConfigurationBuilder setupScript(List<List<String>> batches) {
                this.setupScript = batches;
                return this;
            }

            @Override
            public ContainerConfigurationBuilder tearDownScript(List<List<String>> batches) {
                this.tearDownScript = batches;
                return this;
            }

            @Override
            public ContainerConfiguration build() {
                final List<List<String>> setupScript = Collections.unmodifiableList(this.setupScript);
                final List<List<String>> tearDownScript = Collections.unmodifiableList(this.tearDownScript);
                return new ContainerConfiguration(){

                    @Override
                    public List<List<String>> getSetupScript() {
                        return setupScript;
                    }

                    @Override
                    public List<List<String>> getTearDownScript() {
                        return tearDownScript;
                    }
                };
            }
        };
    }

    public static ScriptBuilder createScriptBuilder() {
        return new ScriptBuilder(){
            private List<List<String>> batches = new LinkedList<List<String>>();

            @Override
            public List<List<String>> build() {
                return Collections.unmodifiableList(this.batches);
            }

            @Override
            public ScriptBuilder add(String command) {
                this.batches.add(List.of(command));
                return this;
            }

            @Override
            public BatchBuilder startBatch() {
                final 3 builder = this;
                final LinkedList batch = new LinkedList();
                this.batches.add(batch);
                return new BatchBuilder(){

                    @Override
                    public BatchBuilder add(String command) {
                        batch.add(command);
                        return this;
                    }

                    @Override
                    public ScriptBuilder endBatch() {
                        return builder;
                    }
                };
            }
        };
    }

    public ManagementServerSetupTask(ContainerSetConfiguration config) {
        this.config = config;
    }

    public ManagementServerSetupTask(ContainerConfiguration defaultConfig) {
        this((ContainerSetConfiguration)ManagementServerSetupTask.createContainerSetConfigurationBuilder().defaultContainer(defaultConfig).build());
    }

    public ManagementServerSetupTask(String container, ContainerConfiguration config) {
        this((ContainerSetConfiguration)ManagementServerSetupTask.createContainerSetConfigurationBuilder().addContainer(container, config).build());
    }

    public ManagementServerSetupTask(Set<String> containers, ContainerConfiguration config) {
        this((ContainerSetConfiguration)ManagementServerSetupTask.createContainerSetConfigurationBuilder().addContainers(containers, config).build());
    }

    public void setup(ManagementClient client, String containerId) throws Exception {
        this.configure(client, containerId, ContainerConfiguration::getSetupScript);
    }

    public void tearDown(ManagementClient client, String containerId) throws Exception {
        this.configure(client, containerId, ContainerConfiguration::getTearDownScript);
    }

    private void configure(ManagementClient client, String containerId, Function<ContainerConfiguration, List<List<String>>> script) throws Exception {
        List<List<String>> batches;
        ContainerConfiguration config = this.config.getContainerConfiguration(containerId);
        if (config != null && !(batches = script.apply(config)).isEmpty()) {
            CommandContext context = CLITestUtil.getCommandContext();
            context.connectController();
            for (List<String> batch : batches) {
                if (batch.isEmpty()) continue;
                ModelNode model = ManagementServerSetupTask.createCommandModel(context, batch);
                ModelNode result = client.getControllerClient().execute(model);
                if (!result.get("outcome").asString().equals("failed")) continue;
                throw new RuntimeException(model.toJSONString(true) + ": " + result.get("failure-description").toString());
            }
            ServerReload.reloadIfRequired(client);
        }
    }

    private static ModelNode createCommandModel(CommandContext context, List<String> commands) throws CommandFormatException {
        if (commands.size() == 1) {
            return context.buildRequest(commands.get(0));
        }
        BatchManager manager = context.getBatchManager();
        manager.activateNewBatch();
        Batch batch = manager.getActiveBatch();
        for (String command : commands) {
            batch.add(context.toBatchedCommand(command));
        }
        return batch.toRequest();
    }

    public static interface ContainerSetConfiguration {
        public ContainerConfiguration getContainerConfiguration(String var1);
    }

    public static interface ContainerSetConfigurationBuilder
    extends Builder<ContainerSetConfiguration> {
        public ContainerSetConfigurationBuilder addContainers(Set<String> var1, ContainerConfiguration var2);

        default public ContainerSetConfigurationBuilder addContainer(String container, ContainerConfiguration configuration) {
            return this.addContainers(Set.of(container), configuration);
        }

        public ContainerSetConfigurationBuilder defaultContainer(ContainerConfiguration var1);
    }

    public static interface ContainerConfiguration {
        public List<List<String>> getSetupScript();

        public List<List<String>> getTearDownScript();
    }

    public static interface BatchBuilder
    extends CommandSet<BatchBuilder> {
        public ScriptBuilder endBatch();
    }

    public static interface ScriptBuilder
    extends Builder<List<List<String>>>,
    CommandSet<ScriptBuilder> {
        public BatchBuilder startBatch();
    }

    public static interface CommandSet<B> {
        public B add(String var1);

        default public B add(String pattern, Object ... params) {
            return this.add(String.format(Locale.ROOT, pattern, params));
        }
    }

    public static interface ContainerConfigurationBuilder
    extends Builder<ContainerConfiguration> {
        public ContainerConfigurationBuilder setupScript(List<List<String>> var1);

        public ContainerConfigurationBuilder tearDownScript(List<List<String>> var1);
    }

    public static interface Builder<C> {
        public C build();
    }
}

