/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.SecurityRealm;

public class AggregateSecurityRealm
implements SecurityRealm {
    private final PathAddress address;
    private final String name;
    private final String authenticationRealm;
    private final String authorizationRealm;
    private final String[] authorizationRealms;
    private final String principalTransformer;

    AggregateSecurityRealm(String name, String authenticationRealm, String authorizationRealm, String[] authorizationRealms, String principalTransformer) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"aggregate-realm", (String)name)});
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
        this.authorizationRealms = authorizationRealms;
        this.principalTransformer = principalTransformer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModelNode getAddOperation() {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("authentication-realm").set(this.authenticationRealm);
        if (this.authorizationRealm != null) {
            addOperation.get("authorization-realm").set(this.authorizationRealm);
        }
        if (this.authorizationRealms != null) {
            ModelNode realms = addOperation.get("authorization-realms");
            for (String realmName : this.authorizationRealms) {
                realms.add(realmName);
            }
        }
        if (this.principalTransformer != null) {
            addOperation.get("principal-transformer").set(this.principalTransformer);
        }
        return addOperation;
    }

    public ModelNode getRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)this.address);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getAddOperation(), client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getRemoveOperation(), client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String authenticationRealm;
        private String authorizationRealm;
        private String[] authorizationRealms;
        private String principalTransformer;

        Builder(String name) {
            this.name = name;
        }

        public Builder withAuthenticationRealm(String authenticationRealm) {
            this.authenticationRealm = authenticationRealm;
            return this;
        }

        public Builder withAuthorizationRealm(String authorizationRealm) {
            this.authorizationRealm = authorizationRealm;
            return this;
        }

        public Builder withAuthorizationRealms(String ... authorizationRealms) {
            this.authorizationRealms = authorizationRealms;
            return this;
        }

        public Builder withPrincipalTransformer(String principalTransformer) {
            this.principalTransformer = principalTransformer;
            return this;
        }

        public SecurityRealm build() {
            return new AggregateSecurityRealm(this.name, this.authenticationRealm, this.authorizationRealm, this.authorizationRealms, this.principalTransformer);
        }
    }
}

