/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.StringUtils;
import org.wildfly.test.security.common.elytron.CliFragment;

public class Ocsp
implements CliFragment {
    public static final Ocsp EMPTY = Ocsp.builder().build();
    private final String responder;
    private final String responderKeyStore;
    private final String responderCertificate;
    private final boolean preferCrls;

    private Ocsp(Builder builder) {
        this.responder = builder.responder;
        this.responderKeyStore = builder.responderKeyStore;
        this.responderCertificate = builder.responderCertificate;
        this.preferCrls = builder.preferCrls;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ocsp={ ");
        if (StringUtils.isNotBlank((CharSequence)this.responder)) {
            sb.append(String.format("responder=\"%s\", ", this.responder));
        }
        if (StringUtils.isNotBlank((CharSequence)this.responderKeyStore)) {
            sb.append(String.format("responder-keystore=\"%s\", ", this.responderKeyStore));
        }
        if (StringUtils.isNotBlank((CharSequence)this.responderCertificate)) {
            sb.append(String.format("responder-certificate=\"%s\", ", this.responderCertificate));
        }
        sb.append(String.format("prefer-crls=\"%s\", ", this.preferCrls));
        sb.append("}, ");
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String responder;
        private String responderKeyStore;
        private String responderCertificate;
        private boolean preferCrls;

        private Builder() {
        }

        public Builder withResponder(String responder) {
            this.responder = responder;
            return this;
        }

        public Builder withResponderKeyStore(String responderKeyStore) {
            this.responderKeyStore = responderKeyStore;
            return this;
        }

        public Builder withResponderCertificate(String responderCertificate) {
            this.responderCertificate = responderCertificate;
            return this;
        }

        public Builder withPreferCrls(boolean preferCrls) {
            this.preferCrls = preferCrls;
            return this;
        }

        public Ocsp build() {
            return new Ocsp(this);
        }
    }
}

