/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.as.test.shared.CliUtils;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.test.security.common.elytron.AbstractUserAttributeValuesCapableElement;
import org.wildfly.test.security.common.elytron.SecurityDomain;
import org.wildfly.test.security.common.elytron.UserWithAttributeValues;

public class PropertyFileBasedDomain
extends AbstractUserAttributeValuesCapableElement
implements SecurityDomain {
    private static final Logger LOGGER = Logger.getLogger(PropertyFileBasedDomain.class);
    private File tempFolder;
    protected final String permissionMapper;

    private PropertyFileBasedDomain(Builder builder) {
        super(builder);
        this.permissionMapper = builder.permMapper;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        this.tempFolder = Utils.createTemporaryFolder("ely-" + this.getName());
        Properties usersProperties = new Properties();
        Properties rolesProperties = new Properties();
        for (UserWithAttributeValues user : this.getUsersWithAttributeValues()) {
            usersProperties.setProperty(user.getName(), user.getPassword());
            rolesProperties.setProperty(user.getName(), String.join((CharSequence)",", user.getValues()));
        }
        File usersFile = this.writeProperties(usersProperties, "users.properties");
        File rolesFile = this.writeProperties(rolesProperties, "roles.properties");
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:add(users-properties={path=\"%s\", plain-text=true}, groups-properties={path=\"%s\"})", this.name, CliUtils.asAbsolutePath(usersFile), CliUtils.asAbsolutePath(rolesFile)));
        cli.sendLine(String.format("/subsystem=elytron/simple-role-decoder=%s:add(attribute=groups)", this.name));
        if (this.permissionMapper == null) {
            cli.sendLine(String.format("/subsystem=elytron/constant-permission-mapper=%s:add(permissions=[{class-name=\"%s\"}])", this.name, LoginPermission.class.getName()));
        }
        String permissionMapperName = this.permissionMapper == null ? this.name : this.permissionMapper;
        cli.sendLine(String.format("/subsystem=elytron/security-domain=%s:add(default-realm=%1$s, permission-mapper=%2$s, realms=[{role-decoder=%1$s, realm=%1$s}]", this.name, permissionMapperName));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/security-domain=%s:remove()", this.name));
        if (this.permissionMapper == null) {
            cli.sendLine(String.format("/subsystem=elytron/constant-permission-mapper=%s:remove()", this.name));
        }
        cli.sendLine(String.format("/subsystem=elytron/simple-role-decoder=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:remove()", this.name));
        FileUtils.deleteQuietly((File)this.tempFolder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private File writeProperties(Properties properties, String fileName) throws IOException {
        File result = new File(this.tempFolder, fileName);
        LOGGER.debugv("Creating property file {0}", (Object)result);
        try (FileOutputStream fos = new FileOutputStream(result);){
            properties.store(fos, "$REALM_NAME=" + this.name + "$");
        }
        return result;
    }

    public static final class Builder
    extends AbstractUserAttributeValuesCapableElement.Builder<Builder> {
        private String permMapper;

        private Builder() {
        }

        public PropertyFileBasedDomain build() {
            return new PropertyFileBasedDomain(this);
        }

        public Builder permissionMapper(String name) {
            this.permMapper = name;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

