/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class SimpleRemotingConnector
extends AbstractConfigurableElement {
    private final String authenticationProvider;
    private final String saslAuthenticationFactory;
    private final String saslProtocol;
    private final String securityRealm;
    private final String serverName;
    private final String socketBinding;
    private final String sslContext;

    private SimpleRemotingConnector(Builder builder) {
        super(builder);
        this.authenticationProvider = builder.authenticationProvider;
        this.saslAuthenticationFactory = builder.saslAuthenticationFactory;
        this.saslProtocol = builder.saslProtocol;
        this.securityRealm = builder.securityRealm;
        this.serverName = builder.serverName;
        this.socketBinding = builder.socketBinding;
        this.sslContext = builder.sslContext;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "remoting").append("connector", this.name));
        ModelNodeUtil.setIfNotNull(op, "authentication-provider", this.authenticationProvider);
        ModelNodeUtil.setIfNotNull(op, "sasl-authentication-factory", this.saslAuthenticationFactory);
        ModelNodeUtil.setIfNotNull(op, "sasl-protocol", this.saslProtocol);
        ModelNodeUtil.setIfNotNull(op, "security-realm", this.securityRealm);
        ModelNodeUtil.setIfNotNull(op, "server-name", this.serverName);
        ModelNodeUtil.setIfNotNull(op, "socket-binding", this.socketBinding);
        ModelNodeUtil.setIfNotNull(op, "ssl-context", this.sslContext);
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "remoting").append("connector", this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String authenticationProvider;
        private String saslAuthenticationFactory;
        private String saslProtocol;
        private String securityRealm;
        private String serverName;
        private String socketBinding;
        private String sslContext;

        private Builder() {
        }

        public Builder withAuthenticationProvider(String authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
            return this;
        }

        public Builder withSaslAuthenticationFactory(String saslAuthenticationFactory) {
            this.saslAuthenticationFactory = saslAuthenticationFactory;
            return this;
        }

        public Builder withSaslProtocol(String saslProtocol) {
            this.saslProtocol = saslProtocol;
            return this;
        }

        public Builder withSecurityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
            return this;
        }

        public Builder withServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder withSocketBinding(String socketBinding) {
            this.socketBinding = socketBinding;
            return this;
        }

        public Builder withSslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public SimpleRemotingConnector build() {
            return new SimpleRemotingConnector(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

