/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.MechanismConfiguration;
import org.wildfly.test.security.common.elytron.SaslAuthenticationFactory;

public class SimpleSaslAuthenticationFactory
extends AbstractConfigurableElement
implements SaslAuthenticationFactory {
    private final List<MechanismConfiguration> mechanismConfigurations;
    private final String saslServerFactory;
    private final String securityDomain;

    private SimpleSaslAuthenticationFactory(Builder builder) {
        super(builder);
        this.mechanismConfigurations = new ArrayList<MechanismConfiguration>(builder.mechanismConfigurations);
        this.saslServerFactory = Objects.requireNonNull(builder.saslServerFactory, "saslServerFactory must be not-null");
        this.securityDomain = Objects.requireNonNull(builder.securityDomain, "securityDomain must be not-null");
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("sasl-authentication-factory", this.name));
        ModelNodeUtil.setIfNotNull(op, "sasl-server-factory", this.saslServerFactory);
        ModelNodeUtil.setIfNotNull(op, "security-domain", this.securityDomain);
        if (!this.mechanismConfigurations.isEmpty()) {
            ModelNode confs = op.get("mechanism-configurations");
            for (MechanismConfiguration conf : this.mechanismConfigurations) {
                confs.add(conf.toModelNode());
            }
        }
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("sasl-authentication-factory", this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private List<MechanismConfiguration> mechanismConfigurations = new ArrayList<MechanismConfiguration>();
        private String saslServerFactory;
        private String securityDomain;

        private Builder() {
        }

        public Builder addMechanismConfiguration(MechanismConfiguration mechanismConfiguration) {
            this.mechanismConfigurations.add(mechanismConfiguration);
            return this;
        }

        public Builder withSaslServerFactory(String saslServerFactory) {
            this.saslServerFactory = saslServerFactory;
            return this;
        }

        public Builder withSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public SimpleSaslAuthenticationFactory build() {
            return new SimpleSaslAuthenticationFactory(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

