/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Status;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.jboss.as.test.integration.transactions.TestSynchronization;
import org.jboss.as.test.integration.transactions.TestXAResource;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingletonRemote;
import org.jboss.as.test.shared.TimeoutUtil;
import org.junit.Assert;

public final class TxTestUtil {
    public static final int timeoutWaitTime_ms = 2500;

    private TxTestUtil() {
    }

    public static TestXAResource enlistTestXAResource(TransactionManager tm, TransactionCheckerSingleton checker) {
        try {
            return TxTestUtil.enlistTestXAResource(tm.getTransaction(), checker);
        }
        catch (SystemException se) {
            throw new RuntimeException(String.format("Can't obtain transaction for transaction manager '%s' to enlist %s", tm, TestXAResource.class.getName()), se);
        }
    }

    public static TestXAResource enlistTestXAResource(Transaction txn, TransactionCheckerSingleton checker) {
        TestXAResource xaResource = new TestXAResource(checker);
        try {
            txn.enlistResource((XAResource)xaResource);
        }
        catch (RollbackException | SystemException | IllegalStateException e) {
            throw new RuntimeException("Can't enlist test xa resource '" + xaResource + "'", e);
        }
        return xaResource;
    }

    public static void enlistTestXAResource(Transaction txn, XAResource xaResource) {
        try {
            txn.enlistResource(xaResource);
        }
        catch (RollbackException | SystemException | IllegalStateException e) {
            throw new RuntimeException("Can't enlist test xa resource '" + xaResource + "'", e);
        }
    }

    public static void addSynchronization(TransactionManager tm, TransactionCheckerSingletonRemote checker) {
        try {
            TxTestUtil.addSynchronization(tm.getTransaction(), checker);
        }
        catch (SystemException se) {
            throw new RuntimeException(String.format("Can't obtain transaction for transaction manager '%s' to enlist add test synchronization '%s'", new Object[0]), se);
        }
    }

    public static void addSynchronization(Transaction txn, TransactionCheckerSingletonRemote checker) {
        TestSynchronization synchro = new TestSynchronization(checker);
        try {
            txn.registerSynchronization((Synchronization)synchro);
        }
        catch (RollbackException | SystemException | IllegalStateException e) {
            throw new RuntimeException("Can't register synchronization '" + synchro + "' to txn '" + txn + "'", e);
        }
    }

    public static void addSynchronization(TransactionSynchronizationRegistry registry, TransactionCheckerSingletonRemote checker) {
        TestSynchronization synchro = new TestSynchronization(checker);
        try {
            registry.registerInterposedSynchronization((Synchronization)synchro);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Can't register synchronization '" + synchro + "' to synchro registry '" + registry + "'", e);
        }
    }

    public static void waitForTimeout(TransactionManager tm) throws SystemException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)TimeoutUtil.adjust((int)2500) && tm.getStatus() == 0) {
            Thread.sleep(200L);
        }
    }

    public static void checkTransactionExists(TransactionManager tm, boolean isExpectTransaction) {
        try {
            Transaction tx = tm.getTransaction();
            if (!isExpectTransaction && tx != null && tx.getStatus() != 6) {
                Assert.fail((String)"We do not expect transaction would be active - we haven't activated it in BMT bean");
            } else if (isExpectTransaction && (tx == null || tx.getStatus() != 0)) {
                Assert.fail((String)"We do expect tranaction would be active - we have alredy activated it in BMT bean");
            }
        }
        catch (SystemException e) {
            throw new RuntimeException("Cannot get the current transaction from injected TransationManager!", e);
        }
    }

    public static String getStatusAsString(int statusCode) {
        switch (statusCode) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
        }
        throw new IllegalStateException("Can't determine status code " + statusCode + " as transaction status code defined under " + Status.class.getName());
    }
}

