/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.containers;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.util.List;
import org.jboss.as.test.shared.observability.containers.BaseContainer;
import org.jboss.as.test.shared.observability.signals.jaeger.JaegerResponse;
import org.jboss.as.test.shared.observability.signals.jaeger.JaegerTrace;
import org.junit.Assert;

class JaegerContainer
extends BaseContainer<JaegerContainer> {
    public static final String IMAGE_NAME = "jaegertracing/all-in-one";
    public static final String IMAGE_VERSION = "1.53.0";
    public static final int PORT_JAEGER_QUERY = 16686;
    public static final int PORT_JAEGER_OTLP = 4317;

    public JaegerContainer() {
        super("Jaeger", IMAGE_NAME, IMAGE_VERSION, List.of(Integer.valueOf(16686), Integer.valueOf(4317)));
        ((JaegerContainer)this.withNetworkAliases(new String[]{"jaeger"})).withEnv("COLLECTOR_OTLP_ENABLED", "true");
    }

    public void start() {
        super.start();
        this.debugLog("Query port: " + this.getMappedPort(16686));
        this.debugLog("OTLP port: " + this.getMappedPort(4317));
        this.debugLog("port bindings: " + this.getPortBindings());
    }

    public List<JaegerTrace> getTraces(String serviceName) throws InterruptedException {
        try (Client client = ClientBuilder.newClient();){
            this.waitForDataToAppear(serviceName);
            List<JaegerTrace> list = ((JaegerResponse)client.target(this.getJaegerEndpoint() + "/api/traces?service=" + serviceName).request().get().readEntity(JaegerResponse.class)).getData();
            return list;
        }
    }

    private String getJaegerEndpoint() {
        return "http://localhost:" + this.getMappedPort(16686);
    }

    private void waitForDataToAppear(String serviceName) {
        try (Client client = ClientBuilder.newClient();){
            boolean found = false;
            int count = 0;
            while (count < 30) {
                String response = (String)client.target(this.getJaegerEndpoint() + "/api/services").request().get().readEntity(String.class);
                if (response.contains(serviceName)) {
                    found = true;
                    break;
                }
                ++count;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Assert.assertTrue((String)"Expected service name not found", (boolean)found);
        }
    }
}

