/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.setuptasks;

import org.jboss.arquillian.testcontainers.api.DockerRequired;
import org.jboss.arquillian.testcontainers.api.Testcontainer;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.observability.containers.OpenTelemetryCollectorContainer;
import org.jboss.as.test.shared.observability.setuptasks.AbstractSetupTask;
import org.jboss.dmr.ModelNode;
import org.junit.AssumptionViolatedException;

@DockerRequired(value=AssumptionViolatedException.class)
public class OpenTelemetrySetupTask
extends AbstractSetupTask {
    private static final String SUBSYSTEM_NAME = "opentelemetry";
    private static final ModelNode extensionAddress = Operations.createAddress((String[])new String[]{"extension", "org.wildfly.extension.opentelemetry"});
    private static final ModelNode subsystemAddress = Operations.createAddress((String[])new String[]{"subsystem", "opentelemetry"});
    @Testcontainer
    private OpenTelemetryCollectorContainer otelCollectorContainer;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, extensionAddress))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)extensionAddress));
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, subsystemAddress))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)subsystemAddress));
        }
        this.executeOp(managementClient, this.writeAttribute(SUBSYSTEM_NAME, "batch-delay", "1"));
        this.executeOp(managementClient, this.writeAttribute(SUBSYSTEM_NAME, "sampler-type", "on"));
        this.executeOp(managementClient, this.writeAttribute(SUBSYSTEM_NAME, "endpoint", this.otelCollectorContainer.getOtlpGrpcEndpoint()));
        ServerReload.reloadIfRequired(managementClient);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.otelCollectorContainer.stop();
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)subsystemAddress));
        this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)extensionAddress));
        ServerReload.reloadIfRequired(managementClient);
    }
}

