/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.containers;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.as.test.shared.observability.containers.BaseContainer;
import org.jboss.as.test.shared.observability.containers.JaegerContainer;
import org.jboss.as.test.shared.observability.signals.PrometheusMetric;
import org.jboss.as.test.shared.observability.signals.jaeger.JaegerTrace;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class OpenTelemetryCollectorContainer
extends BaseContainer<OpenTelemetryCollectorContainer> {
    public static final String IMAGE_NAME = "otel/opentelemetry-collector";
    public static final String IMAGE_VERSION = "0.103.1";
    public static final int OTLP_GRPC_PORT = 4317;
    public static final int OTLP_HTTP_PORT = 4318;
    public static final int PROMETHEUS_PORT = 1234;
    public static final int HEALTH_CHECK_PORT = 13133;
    public static final String OTEL_COLLECTOR_CONFIG_YAML = "/etc/otel-collector-config.yaml";
    private JaegerContainer jaegerContainer;

    public OpenTelemetryCollectorContainer() {
        super("OpenTelemetryCollector", IMAGE_NAME, IMAGE_VERSION, List.of(Integer.valueOf(4317), Integer.valueOf(4318), Integer.valueOf(13133), Integer.valueOf(1234)));
        this.withCopyToContainer((Transferable)MountableFile.forClasspathResource((String)(((Object)((Object)this)).getClass().getPackageName().replace(".", "/") + "/otel-collector-config.yaml")), OTEL_COLLECTOR_CONFIG_YAML);
        this.withCommand("--config /etc/otel-collector-config.yaml");
        this.jaegerContainer = new JaegerContainer();
    }

    public void start() {
        super.start();
        this.jaegerContainer.start();
        this.debugLog("OTLP gRPC port: " + this.getMappedPort(4317));
        this.debugLog("OTLP HTTP port: " + this.getMappedPort(4318));
        this.debugLog("Prometheus port: " + this.getMappedPort(1234));
        this.debugLog("port bindings: " + this.getPortBindings());
    }

    public synchronized void stop() {
        this.jaegerContainer.stop();
        super.stop();
    }

    public String getOtlpGrpcEndpoint() {
        return "http://localhost:" + this.getMappedPort(4317);
    }

    public String getOtlpHttpEndpoint() {
        return "http://localhost:" + this.getMappedPort(4318);
    }

    public String getPrometheusUrl() {
        return "http://localhost:" + this.getMappedPort(1234) + "/metrics";
    }

    public List<JaegerTrace> getTraces(String serviceName) throws InterruptedException {
        return this.jaegerContainer != null ? this.jaegerContainer.getTraces(serviceName) : Collections.emptyList();
    }

    public List<PrometheusMetric> fetchMetrics(String nameToMonitor) throws InterruptedException {
        String body = "";
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getPrometheusUrl());
            boolean found = false;
            for (int attemptCount = 0; !found && attemptCount < 30; ++attemptCount) {
                Thread.sleep(1000L);
                body = (String)target.request().get().readEntity(String.class);
                found = body.contains(nameToMonitor);
            }
        }
        return this.buildPrometheusMetrics(body);
    }

    private List<PrometheusMetric> buildPrometheusMetrics(String body) {
        if (body.isEmpty()) {
            return Collections.emptyList();
        }
        String[] entries = body.split("\n");
        HashMap help = new HashMap();
        HashMap type = new HashMap();
        LinkedList<PrometheusMetric> metrics = new LinkedList<PrometheusMetric>();
        Arrays.stream(entries).forEach(e -> {
            if (e.startsWith("# HELP")) {
                this.extractMetadata(help, (String)e);
            } else if (e.startsWith("# TYPE")) {
                this.extractMetadata(type, (String)e);
            } else {
                String[] parts = e.split("[{}]");
                String key = parts[0];
                Map<String, String> tags = Arrays.stream(parts[1].split(",")).map(t -> t.split("=")).collect(Collectors.toMap(i -> i[0], i -> i[1].replaceAll("^\"", "").replaceAll("\"$", "")));
                metrics.add(new PrometheusMetric(key, tags, parts[2].trim(), (String)type.get(key), (String)help.get(key)));
            }
        });
        return metrics;
    }

    private void extractMetadata(Map<String, String> target, String source) {
        String[] parts = source.split(" ");
        target.put(parts[2], Arrays.stream(Arrays.copyOfRange(parts, 3, parts.length)).reduce("", (total, element) -> total + " " + element));
    }
}

