/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public class CustomPrincipalTransformer
implements ConfigurableElement {
    private final PathAddress address;
    private final String name;
    private final String className;
    private final String module;
    private final Map<String, String> configuration;

    protected CustomPrincipalTransformer(String name, String className, String module, Map<String, String> configuration) {
        this.name = name;
        this.className = className;
        this.module = module;
        this.configuration = configuration;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"custom-principal-transformer", (String)name)});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        ModelNodeUtil.setIfNotNull(addOperation, "class-name", this.className);
        ModelNodeUtil.setIfNotNull(addOperation, "module", this.module);
        if (this.configuration.size() > 0) {
            StringBuilder configurationPairs = new StringBuilder();
            this.configuration.forEach((key, value) -> configurationPairs.append(',').append((String)key).append('=').append((String)value));
            configurationPairs.replace(0, 1, "{").append('}');
            addOperation.get("configuration").set(configurationPairs.toString());
        }
        Utils.applyUpdate(addOperation, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)this.address), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String className;
        private String module;
        private Map<String, String> configuration = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder withModule(String module) {
            this.module = module;
            return this;
        }

        public Builder addConfiguration(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Builder addConfigurations(Map<String, String> configuration) {
            this.configuration.putAll(configuration);
            return this;
        }

        public CustomPrincipalTransformer build() {
            return new CustomPrincipalTransformer(this.name, this.className, this.module, this.configuration);
        }
    }
}

