/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class FileAuditLog
extends AbstractConfigurableElement {
    private final String format;
    private final Boolean paramSynchronized;
    private final String path;
    private final String relativeTo;
    private final String encoding;

    private FileAuditLog(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.paramSynchronized = builder.paramSynchronized;
        this.path = builder.path;
        this.relativeTo = builder.relativeTo;
        this.encoding = builder.encoding;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder command = new StringBuilder("/subsystem=elytron/file-audit-log=").append(this.name).append(":add(");
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            command.append("format=\"").append(this.format).append("\", ");
        }
        if (this.paramSynchronized != null) {
            command.append("synchronized=").append(this.paramSynchronized).append(", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            command.append("path=\"").append(this.path).append("\", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.relativeTo)) {
            command.append("relative-to=\"").append(this.relativeTo).append("\", ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.encoding)) {
            command.append("encoding=\"").append(this.encoding).append("\", ");
        }
        command.append(")");
        cli.sendLine(command.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/file-audit-log=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String path;
        private String relativeTo;
        private Boolean paramSynchronized;
        private String format;
        private String encoding;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withRelativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public Builder withSynchronized(boolean paramSynchronized) {
            this.paramSynchronized = paramSynchronized;
            return this;
        }

        public Builder withFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder withEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public FileAuditLog build() {
            return new FileAuditLog(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

