/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.PermissionMapper;
import org.wildfly.test.security.common.elytron.PermissionRef;

public class ConstantPermissionMapper
extends AbstractConfigurableElement
implements PermissionMapper {
    private static final String CONSTANT_PERMISSION_MAPPER = "constant-permission-mapper";
    private static final PathAddress PATH_ELYTRON = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron");
    private final PermissionRef[] permissions;

    private ConstantPermissionMapper(Builder builder) {
        super(builder);
        this.permissions = builder.permissions;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PATH_ELYTRON.append(CONSTANT_PERMISSION_MAPPER, this.name));
        if (this.permissions != null) {
            ModelNode permissionsNode = op.get("permissions");
            for (PermissionRef permissionRef : this.permissions) {
                ModelNode permissionRefNode = new ModelNode();
                permissionRefNode.get("class-name").set(permissionRef.getClassName());
                ModelNodeUtil.setIfNotNull(permissionRefNode, "module", permissionRef.getModule());
                ModelNodeUtil.setIfNotNull(permissionRefNode, "target-name", permissionRef.getTargetName());
                ModelNodeUtil.setIfNotNull(permissionRefNode, "action", permissionRef.getAction());
                permissionsNode.add(permissionRefNode);
            }
        }
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PATH_ELYTRON.append(CONSTANT_PERMISSION_MAPPER, this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private PermissionRef[] permissions;

        private Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ConstantPermissionMapper build() {
            return new ConstantPermissionMapper(this);
        }

        public Builder withPermissions(PermissionRef ... permissions) {
            this.permissions = permissions;
            return this;
        }
    }
}

