/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.wildfly.test.security.common.elytron.CliFragment;

public class MatchRules
implements CliFragment {
    private final String authenticationConfiguration;
    private final String matchAbstractType;
    private final String matchAbstractTypeAuthority;
    private final String matchHost;
    private final String matchLocalSecurityDomain;
    private final Boolean matchNoUser;
    private final String matchPath;
    private final String matchPort;
    private final String matchProtocol;
    private final String matchPurpose;
    private final String matchUrn;
    private final String matchUser;
    private final String sslContext;

    private MatchRules(Builder builder) {
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.matchAbstractType = builder.matchAbstractType;
        this.matchAbstractTypeAuthority = builder.matchAbstractTypeAuthority;
        this.matchHost = builder.matchHost;
        this.matchLocalSecurityDomain = builder.matchLocalSecurityDomain;
        this.matchNoUser = builder.matchNoUser;
        this.matchPath = builder.matchPath;
        this.matchPort = builder.matchPort;
        this.matchProtocol = builder.matchProtocol;
        this.matchPurpose = builder.matchPurpose;
        this.matchUrn = builder.matchUrn;
        this.matchUser = builder.matchUser;
        this.sslContext = builder.sslContext;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder("match-rules=[{");
        if (this.authenticationConfiguration != null && !this.authenticationConfiguration.isEmpty()) {
            sb.append(String.format("authentication-configuration=\"%s\", ", this.authenticationConfiguration));
        }
        if (this.matchAbstractType != null && !this.matchAbstractType.isEmpty()) {
            sb.append(String.format("match-abstract-type=\"%s\", ", this.matchAbstractType));
        }
        if (this.matchAbstractTypeAuthority != null && !this.matchAbstractTypeAuthority.isEmpty()) {
            sb.append(String.format("match-abstract-type-authority=\"%s\", ", this.matchAbstractTypeAuthority));
        }
        if (this.matchHost != null && !this.matchHost.isEmpty()) {
            sb.append(String.format("match-host=\"%s\", ", this.matchHost));
        }
        if (this.matchLocalSecurityDomain != null && !this.matchLocalSecurityDomain.isEmpty()) {
            sb.append(String.format("match-local-security-domain=\"%s\", ", this.matchLocalSecurityDomain));
        }
        if (this.matchNoUser != null) {
            sb.append(String.format("match-no-user=\"%s\", ", this.matchNoUser.toString()));
        }
        if (this.matchPath != null && !this.matchPath.isEmpty()) {
            sb.append(String.format("match-path=\"%s\", ", this.matchPath));
        }
        if (this.matchPort != null && !this.matchPort.isEmpty()) {
            sb.append(String.format("match-port=\"%s\", ", this.matchPort));
        }
        if (this.matchProtocol != null && !this.matchProtocol.isEmpty()) {
            sb.append(String.format("match-protocol=\"%s\", ", this.matchProtocol));
        }
        if (this.matchPurpose != null && !this.matchPurpose.isEmpty()) {
            sb.append(String.format("match-purpose=\"%s\", ", this.matchPurpose));
        }
        if (this.matchUrn != null && !this.matchUrn.isEmpty()) {
            sb.append(String.format("match-urn=\"%s\", ", this.matchUrn));
        }
        if (this.matchUser != null && !this.matchUser.isEmpty()) {
            sb.append(String.format("match-user=\"%s\", ", this.matchUser));
        }
        if (this.sslContext != null && !this.sslContext.isEmpty()) {
            sb.append(String.format("ssl-context=\"%s\", ", this.sslContext));
        }
        sb.append("}], ");
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authenticationConfiguration;
        private String matchAbstractTypeAuthority;
        private String matchAbstractType;
        private String matchHost;
        private String matchLocalSecurityDomain;
        private Boolean matchNoUser;
        private String matchPath;
        private String matchPort;
        private String matchProtocol;
        private String matchPurpose;
        private String matchUrn;
        private String matchUser;
        private String sslContext;

        private Builder() {
        }

        public Builder withAuthenticationConfiguration(String authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public Builder withMatchAbstractType(String matchAbstractType) {
            this.matchAbstractType = matchAbstractType;
            return this;
        }

        public Builder withMatchAbstractTypeAuthority(String matchAbstractTypeAuthority) {
            this.matchAbstractTypeAuthority = matchAbstractTypeAuthority;
            return this;
        }

        public Builder withMatchHost(String matchHost) {
            this.matchHost = matchHost;
            return this;
        }

        public Builder withMatchLocalSecurityDomain(String matchLocalSecurityDomain) {
            this.matchLocalSecurityDomain = matchLocalSecurityDomain;
            return this;
        }

        public Builder withMatchNoUser(Boolean matchNoUser) {
            this.matchNoUser = matchNoUser;
            return this;
        }

        public Builder withMatchPath(String matchPath) {
            this.matchPath = matchPath;
            return this;
        }

        public Builder withMatchPort(String matchPort) {
            this.matchPort = matchPort;
            return this;
        }

        public Builder withMatchProtocol(String matchProtocol) {
            this.matchProtocol = matchProtocol;
            return this;
        }

        public Builder withMatchPurpose(String matchPurpose) {
            this.matchPurpose = matchPurpose;
            return this;
        }

        public Builder withMatchUrn(String matchUrn) {
            this.matchUrn = matchUrn;
            return this;
        }

        public Builder withMatchUser(String matchUser) {
            this.matchUser = matchUser;
            return this;
        }

        public Builder withSslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public MatchRules build() {
            return new MatchRules(this);
        }
    }
}

