/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractMechanismConfiguration;
import org.wildfly.test.security.common.elytron.MechanismRealmConfiguration;

public class MechanismConfiguration
extends AbstractMechanismConfiguration {
    private final String mechanismName;
    private final String hostName;
    private final String protocol;
    private final String credentialSecurityFactory;
    private final List<MechanismRealmConfiguration> mechanismRealmConfigurations;

    private MechanismConfiguration(Builder builder) {
        super(builder);
        this.mechanismName = builder.mechanismName;
        this.hostName = builder.hostName;
        this.protocol = builder.protocol;
        this.credentialSecurityFactory = builder.credentialSecurityFactory;
        this.mechanismRealmConfigurations = new ArrayList<MechanismRealmConfiguration>(builder.mechanismRealmConfigurations);
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getCredentialSecurityFactory() {
        return this.credentialSecurityFactory;
    }

    public List<MechanismRealmConfiguration> getMechanismRealmConfigurations() {
        return this.mechanismRealmConfigurations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ModelNode toModelNode() {
        ModelNode node = super.toModelNode();
        ModelNodeUtil.setIfNotNull(node, "mechanism-name", this.mechanismName);
        ModelNodeUtil.setIfNotNull(node, "host-name", this.hostName);
        ModelNodeUtil.setIfNotNull(node, "protocol", this.protocol);
        ModelNodeUtil.setIfNotNull(node, "credential-security-factory", this.credentialSecurityFactory);
        if (!this.mechanismRealmConfigurations.isEmpty()) {
            ModelNode confs = node.get("mechanism-realm-configurations");
            for (MechanismRealmConfiguration conf : this.mechanismRealmConfigurations) {
                confs.add(conf.toModelNode());
            }
        }
        return node;
    }

    public static final class Builder
    extends AbstractMechanismConfiguration.Builder<Builder> {
        private String mechanismName;
        private String hostName;
        private String protocol;
        private String credentialSecurityFactory;
        private List<MechanismRealmConfiguration> mechanismRealmConfigurations = new ArrayList<MechanismRealmConfiguration>();

        private Builder() {
        }

        public Builder withMechanismName(String mechanismName) {
            this.mechanismName = mechanismName;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withCredentialSecurityFactory(String credentialSecurityFactory) {
            this.credentialSecurityFactory = credentialSecurityFactory;
            return this;
        }

        public Builder addMechanismRealmConfiguration(MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.mechanismRealmConfigurations.add(mechanismRealmConfiguration);
            return this;
        }

        public MechanismConfiguration build() {
            return new MechanismConfiguration(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

