/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.undertow.common;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.CredentialReference;

public class SingleSignOnSetting {
    private final String clientSSLContext;
    private final String cookieName;
    private final CredentialReference credentialReference;
    private final String domain;
    private final boolean httpOnly;
    private final String keyAlias;
    private final String keyStore;
    private final String path;
    private final boolean secure;

    private SingleSignOnSetting(Builder builder) {
        this.clientSSLContext = builder.clientSSLContext;
        this.cookieName = builder.cookieName;
        this.credentialReference = builder.credentialReference;
        this.domain = builder.domain;
        this.httpOnly = builder.httpOnly;
        this.keyAlias = builder.keyAlias;
        this.keyStore = builder.keyStore;
        this.path = builder.path;
        this.secure = builder.secure;
    }

    ModelNode getAddOperation(PathAddress parentAddress) {
        PathAddress settingsAddress = PathAddress.pathAddress((PathAddress)parentAddress, (PathElement[])new PathElement[]{PathElement.pathElement((String)"setting", (String)"single-sign-on")});
        ModelNode response = Util.createAddOperation((PathAddress)settingsAddress);
        ModelNodeUtil.setIfNotNull(response, "client-ssl-context", this.clientSSLContext);
        ModelNodeUtil.setIfNotNull(response, "cookie-name", this.cookieName);
        if (this.credentialReference != null) {
            response.get("credential-reference").set(this.credentialReference.asModelNode());
        }
        ModelNodeUtil.setIfNotNull(response, "domain", this.domain);
        if (this.httpOnly) {
            response.get("http-only").set(true);
        }
        ModelNodeUtil.setIfNotNull(response, "key-alias", this.keyAlias);
        ModelNodeUtil.setIfNotNull(response, "key-store", this.keyStore);
        ModelNodeUtil.setIfNotNull(response, "path", this.path);
        if (this.secure) {
            response.get("secure").set(true);
        }
        return response;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clientSSLContext;
        private String cookieName;
        private CredentialReference credentialReference;
        private String domain;
        private boolean httpOnly = false;
        private String keyAlias;
        private String keyStore;
        private String path;
        private boolean secure = false;

        Builder() {
        }

        public Builder withClientSSLContext(String clientSSLContext) {
            this.clientSSLContext = clientSSLContext;
            return this;
        }

        public Builder withCookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder withCredentialReference(CredentialReference credentialReference) {
            this.credentialReference = credentialReference;
            return this;
        }

        public Builder withDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder withHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder withKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Builder withKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public SingleSignOnSetting build() {
            return new SingleSignOnSetting(this);
        }
    }
}

