/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public final class KeyStoreUtils {
    public static KeyStore generateKeystore(KeyEntry[] keys, CertEntry[] trustCerts, String keystorePassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return KeyStoreUtils.generateKeystore(KeyStoreType.JKS, keys, trustCerts, keystorePassword);
    }

    public static KeyStore generateKeystore(KeyStoreType keyStoreType, KeyEntry[] keys, CertEntry[] trustCerts, String keystorePassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keystore = KeyStore.getInstance(keyStoreType.toString());
        keystore.load(null, null);
        if (keys != null) {
            for (KeyEntry key : keys) {
                keystore.setKeyEntry(key.name, key.keyPair.getPrivate(), keystorePassword.toCharArray(), key.certificates);
            }
        }
        if (trustCerts != null) {
            for (CertEntry cert : trustCerts) {
                keystore.setCertificateEntry(cert.name, cert.certificate);
            }
        }
        return keystore;
    }

    public static void saveKeystore(KeyStore keyStore, String keystorePassword, File keystoreFile) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStoreUtils.saveKeystore(keyStore, keystorePassword, keystoreFile.getAbsolutePath());
    }

    public static void saveKeystore(KeyStore keyStore, String keystorePassword, String keystoreFile) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        if (keystoreFile == null) {
            throw new RuntimeException("There has to be defined path to generated keystore file!");
        }
        FileOutputStream ksOut = new FileOutputStream(keystoreFile);
        keyStore.store(ksOut, keystorePassword.toCharArray());
        ((OutputStream)ksOut).close();
    }

    public static enum KeyStoreType {
        JKS,
        PKCS12;

    }

    public static class KeyEntry {
        private String name;
        private KeyPair keyPair;
        private Certificate[] certificates;

        public KeyEntry(String name, KeyPair keyPair, Certificate certificate) {
            this.name = name;
            this.keyPair = keyPair;
            this.certificates = new Certificate[]{certificate};
        }

        public KeyEntry(String name, KeyPair keyPair, Certificate[] certificates) {
            this.name = name;
            this.keyPair = keyPair;
            this.certificates = certificates;
        }
    }

    public static class CertEntry {
        private String name;
        private Certificate certificate;

        public CertEntry(String name, Certificate certificate) {
            this.name = name;
            this.certificate = certificate;
        }
    }
}

