/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.CliFragment;

public class CredentialReference
implements CliFragment {
    public static final CredentialReference EMPTY = CredentialReference.builder().build();
    private final String store;
    private final String alias;
    private final String clearText;

    private CredentialReference(Builder builder) {
        this.store = builder.store;
        this.alias = builder.alias;
        this.clearText = builder.clearText;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.alias) || StringUtils.isNotBlank((CharSequence)this.clearText) || StringUtils.isNotBlank((CharSequence)this.store)) {
            sb.append("credential-reference={ ");
            if (StringUtils.isNotBlank((CharSequence)this.alias)) {
                sb.append(String.format("alias=\"%s\", ", this.alias));
            }
            if (StringUtils.isNotBlank((CharSequence)this.store)) {
                sb.append(String.format("store=\"%s\", ", this.store));
            }
            if (StringUtils.isNotBlank((CharSequence)this.clearText)) {
                sb.append(String.format("clear-text=\"%s\"", this.clearText));
            }
            sb.append("}, ");
        }
        return sb.toString();
    }

    public ModelNode asModelNode() {
        ModelNode credentialReference = new ModelNode();
        if (this.alias != null) {
            credentialReference.get("alias").set(this.alias);
        }
        if (this.store != null) {
            credentialReference.get("store").set(this.store);
        }
        if (this.clearText != null) {
            credentialReference.get("clear-text").set(this.clearText);
        }
        return credentialReference.asObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String store;
        private String alias;
        private String clearText;

        private Builder() {
        }

        public Builder withStore(String store) {
            this.store = store;
            return this;
        }

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder withClearText(String clearText) {
            this.clearText = clearText;
            return this;
        }

        public CredentialReference build() {
            return new CredentialReference(this);
        }
    }
}

