/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config;

import org.jboss.as.test.integration.security.common.config.JSSE;
import org.jboss.as.test.integration.security.common.config.JaspiAuthn;
import org.jboss.as.test.integration.security.common.config.SecurityModule;

public class SecurityDomain {
    public static final String DEFAULT_NAME = "test-security-domain";
    private final String name;
    private final String cacheType;
    private final SecurityModule[] loginModules;
    private final SecurityModule[] authorizationModules;
    private final SecurityModule[] mappingModules;
    private final JaspiAuthn jaspiAuthn;
    private final JSSE jsse;

    private SecurityDomain(Builder builder) {
        this.name = builder.name != null ? builder.name : DEFAULT_NAME;
        this.loginModules = builder.loginModules;
        this.authorizationModules = builder.authorizationModules;
        this.mappingModules = builder.mappingModules;
        this.jaspiAuthn = builder.jaspiAuthn;
        this.jsse = builder.jsse;
        this.cacheType = builder.cacheType;
    }

    public String getName() {
        return this.name;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public SecurityModule[] getLoginModules() {
        return this.loginModules;
    }

    public SecurityModule[] getAuthorizationModules() {
        return this.authorizationModules;
    }

    public SecurityModule[] getMappingModules() {
        return this.mappingModules;
    }

    public JaspiAuthn getJaspiAuthn() {
        return this.jaspiAuthn;
    }

    public JSSE getJsse() {
        return this.jsse;
    }

    public static class Builder {
        private String name;
        private String cacheType;
        private SecurityModule[] loginModules;
        private SecurityModule[] authorizationModules;
        private SecurityModule[] mappingModules;
        private JaspiAuthn jaspiAuthn;
        private JSSE jsse;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cacheType(String cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder loginModules(SecurityModule ... loginModules) {
            this.loginModules = loginModules;
            return this;
        }

        public Builder authorizationModules(SecurityModule ... authorizationModules) {
            this.authorizationModules = authorizationModules;
            return this;
        }

        public Builder mappingModules(SecurityModule ... mappingModules) {
            this.mappingModules = mappingModules;
            return this;
        }

        public Builder jaspiAuthn(JaspiAuthn jaspiAuthn) {
            this.jaspiAuthn = jaspiAuthn;
            return this;
        }

        public Builder jsse(JSSE jsse) {
            this.jsse = jsse;
            return this;
        }

        public SecurityDomain build() {
            return new SecurityDomain(this);
        }
    }
}

