/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config.realm;

public class LdapAuthentication {
    private final String connection;
    private final String searchDn;
    private final String searchCredential;
    private final String securityRealm;
    private final String url;
    private final String initialContextFactory;
    private final String advancedFilter;
    private final String baseDn;
    private final String userDn;
    private final Boolean recursive;
    private final String usernameAttribute;
    private final Boolean allowEmptyPasswords;

    private LdapAuthentication(Builder builder) {
        this.connection = builder.connection;
        this.advancedFilter = builder.advancedFilter;
        this.baseDn = builder.baseDn;
        this.userDn = builder.userDn;
        this.recursive = builder.recursive;
        this.usernameAttribute = builder.usernameAttribute;
        this.allowEmptyPasswords = builder.allowEmptyPasswords;
        this.searchDn = builder.searchDn;
        this.searchCredential = builder.searchCredential;
        this.securityRealm = builder.securityRealm;
        this.url = builder.url;
        this.initialContextFactory = builder.initialContextFactory;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getAdvancedFilter() {
        return this.advancedFilter;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String getSearchDn() {
        return this.searchDn;
    }

    public String getSearchCredential() {
        return this.searchCredential;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public String getUrl() {
        return this.url;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public Boolean getAllowEmptyPasswords() {
        return this.allowEmptyPasswords;
    }

    public String toString() {
        return "LdapAuthentication [connection=" + this.connection + ", searchDn=" + this.searchDn + ", searchCredential=" + this.searchCredential + ", securityRealm=" + this.securityRealm + ", url=" + this.url + ", initialContextFactory=" + this.initialContextFactory + ", advancedFilter=" + this.advancedFilter + ", baseDn=" + this.baseDn + ", userDn=" + this.userDn + ", recursive=" + this.recursive + ", usernameAttribute=" + this.usernameAttribute + ", allowEmptyPasswords=" + this.allowEmptyPasswords + "]";
    }

    public static class Builder {
        private String connection;
        private String searchDn;
        private String searchCredential;
        private String securityRealm;
        private String url;
        private String initialContextFactory;
        private String advancedFilter;
        private String baseDn;
        private String userDn;
        private Boolean recursive;
        private String usernameAttribute;
        private Boolean allowEmptyPasswords;

        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder advancedFilter(String advancedFilter) {
            this.advancedFilter = advancedFilter;
            return this;
        }

        public Builder baseDn(String baseDn) {
            this.baseDn = baseDn;
            return this;
        }

        public Builder userDn(String userDn) {
            this.userDn = userDn;
            return this;
        }

        public Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder searchDn(String searchDn) {
            this.searchDn = searchDn;
            return this;
        }

        public Builder searchCredential(String searchCredential) {
            this.searchCredential = searchCredential;
            return this;
        }

        public Builder securityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder initialContextFactory(String initialContextFactory) {
            this.initialContextFactory = initialContextFactory;
            return this;
        }

        public Builder usernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public Builder allowEmptyPasswords(Boolean allowEmptyPasswords) {
            this.allowEmptyPasswords = allowEmptyPasswords;
            return this;
        }

        public LdapAuthentication build() {
            return new LdapAuthentication(this);
        }
    }
}

