/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config.realm;

import org.jboss.as.test.integration.security.common.config.realm.Authentication;
import org.jboss.as.test.integration.security.common.config.realm.Authorization;
import org.jboss.as.test.integration.security.common.config.realm.ServerIdentity;

public class SecurityRealm {
    private final String name;
    private final ServerIdentity serverIdentity;
    private final Authentication authentication;
    private final Authorization authorization;

    private SecurityRealm(Builder builder) {
        this.name = builder.name;
        this.serverIdentity = builder.serverIdentity;
        this.authentication = builder.authentication;
        this.authorization = builder.authorization;
    }

    public String getName() {
        return this.name;
    }

    public ServerIdentity getServerIdentity() {
        return this.serverIdentity;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public String toString() {
        return "SecurityRealm [name=" + this.name + ", serverIdentity=" + this.serverIdentity + ", authentication=" + this.authentication + ", authorization=" + this.authorization + "]";
    }

    public static class Builder {
        private String name;
        private ServerIdentity serverIdentity;
        private Authentication authentication;
        private Authorization authorization;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder serverIdentity(ServerIdentity serverIdentity) {
            this.serverIdentity = serverIdentity;
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public SecurityRealm build() {
            return new SecurityRealm(this);
        }
    }
}

