/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.io.IOException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class DefaultHornetQProviderJMSOperations
implements JMSOperations {
    private final ManagementClient client;
    private static final Logger logger = Logger.getLogger(DefaultHornetQProviderJMSOperations.class);

    public DefaultHornetQProviderJMSOperations(ManagementClient client) {
        this.client = client;
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName) {
        this.createJmsDestination("jms-queue", queueName, jndiName);
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName) {
        this.createJmsDestination("jms-topic", topicName, jndiName);
    }

    @Override
    public void removeJmsQueue(String queueName) {
        this.removeJmsDestination("jms-queue", queueName);
    }

    @Override
    public void removeJmsTopic(String topicName) {
        this.removeJmsDestination("jms-topic", topicName);
    }

    @Override
    public void close() {
    }

    private ModelControllerClient getModelControllerClient() {
        return this.client.getControllerClient();
    }

    private void createJmsDestination(String destinationType, String destinationName, String jndiName) {
        ModelNode createJmsQueueOperation = new ModelNode();
        createJmsQueueOperation.get("operation").set("add");
        createJmsQueueOperation.get("address").add("subsystem", "messaging");
        createJmsQueueOperation.get("address").add("hornetq-server", "default");
        createJmsQueueOperation.get("address").add(destinationType, destinationName);
        createJmsQueueOperation.get("entries").add(jndiName);
        try {
            this.applyUpdate(createJmsQueueOperation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removeJmsDestination(String destinationType, String destinationName) {
        ModelNode removeJmsQueue = new ModelNode();
        removeJmsQueue.get("operation").set("remove");
        removeJmsQueue.get("address").add("subsystem", "messaging");
        removeJmsQueue.get("address").add("hornetq-server", "default");
        removeJmsQueue.get("address").add(destinationType, destinationName);
        try {
            this.applyUpdate(removeJmsQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void applyUpdate(ModelNode update) throws IOException, JMSOperationsException {
        ModelNode result = this.getModelControllerClient().execute(update);
        if (!result.hasDefined("outcome") || !"success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("failure-description")) {
                String failureDesc = result.get("failure-description").toString();
                throw new JMSOperationsException(failureDesc);
            }
            throw new JMSOperationsException("Operation not successful; outcome = " + result.get("outcome"));
        }
        logger.info((Object)("Operation successful for update = " + update.toString()));
    }

    @Override
    public void setSystemProperties(String destination, String resourceAdapter) {
        ModelNode enableSubstitutionOp = new ModelNode();
        enableSubstitutionOp.get("address").set("subsystem", "ee");
        enableSubstitutionOp.get("operation").set("write-attribute");
        enableSubstitutionOp.get("name").set("ejb-annotation-property-replacement");
        enableSubstitutionOp.get("value").set(true);
        ModelNode setDestinationOp = new ModelNode();
        setDestinationOp.get("operation").set("add");
        setDestinationOp.get("address").add("system-property", "destination");
        setDestinationOp.get("value").set(destination);
        ModelNode setResourceAdapterOp = new ModelNode();
        setResourceAdapterOp.get("operation").set("add");
        setResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        setResourceAdapterOp.get("value").set(resourceAdapter);
        try {
            this.applyUpdate(enableSubstitutionOp);
            this.applyUpdate(setDestinationOp);
            this.applyUpdate(setResourceAdapterOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeSystemProperties() {
        ModelNode removeDestinationOp = new ModelNode();
        removeDestinationOp.get("operation").set("remove");
        removeDestinationOp.get("address").add("system-property", "destination");
        ModelNode removeResourceAdapterOp = new ModelNode();
        removeResourceAdapterOp.get("operation").set("remove");
        removeResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        ModelNode disableSubstitutionOp = new ModelNode();
        disableSubstitutionOp.get("address").set("subsystem", "ee");
        disableSubstitutionOp.get("operation").set("write-attribute");
        disableSubstitutionOp.get("name").set("ejb-annotationr-property-replacement");
        disableSubstitutionOp.get("value").set(false);
        try {
            this.applyUpdate(removeDestinationOp);
            this.applyUpdate(removeResourceAdapterOp);
            this.applyUpdate(disableSubstitutionOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

