/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.jboss.as.process.protocol.StreamUtils;

class ProcessWrapper {
    private final String processName;
    private final List<String> command;
    private final Map<String, String> env;
    private final String workingDirectory;
    private Process process;
    private volatile boolean stopped;

    ProcessWrapper(String processName, List<String> command, Map<String, String> env, String workingDirectory) {
        assert (processName != null);
        assert (command != null);
        assert (env != null);
        assert (workingDirectory != null);
        this.processName = processName;
        this.command = command;
        this.env = env;
        this.workingDirectory = workingDirectory;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ProcessWrapper.this.stop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getExitValue() {
        ProcessWrapper processWrapper = this;
        synchronized (processWrapper) {
            return this.process.exitValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws Exception {
        ProcessWrapper processWrapper = this;
        synchronized (processWrapper) {
            if (this.stopped) {
                throw new IllegalStateException();
            }
            ProcessBuilder builder = new ProcessBuilder(this.command);
            builder.redirectErrorStream(true);
            builder.environment().putAll(this.env);
            builder.directory(new File(this.workingDirectory));
            this.process = builder.start();
            InputStream stdout = this.process.getInputStream();
            ConsoleConsumer consoleConsumer = new ConsoleConsumer(stdout, System.out);
            new Thread((Runnable)consoleConsumer, "Console consumer " + this.processName).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int waitFor() throws InterruptedException {
        Process process;
        ProcessWrapper processWrapper = this;
        synchronized (processWrapper) {
            process = this.process;
        }
        if (process != null) {
            return process.waitFor();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        ProcessWrapper processWrapper = this;
        synchronized (processWrapper) {
            boolean stopped = this.stopped;
            if (!stopped) {
                this.stopped = true;
                Process process = this.process;
                if (process != null) {
                    process.destroy();
                }
            }
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private final InputStream source;
        private final PrintStream target;
        private final boolean writeOutput = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String val = System.getProperty("org.jboss.as.writeconsole");
                return val == null || !"false".equals(val);
            }
        });

        private ConsoleConsumer(InputStream source, PrintStream target) {
            this.source = source;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream source = this.source;
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = source.read(buf)) != -1) {
                    if (!this.writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException e) {
                if (!ProcessWrapper.this.stopped) {
                    e.printStackTrace(this.target);
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)source);
            }
        }
    }
}

