/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.interfaces;

import java.util.Iterator;
import org.jboss.as.cli.scriptsupport.CLI;
import org.jboss.as.test.integration.management.interfaces.ManagementInterface;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CliManagementInterface
implements ManagementInterface {
    private final CLI client;

    protected CliManagementInterface(CLI client) {
        this.client = client;
    }

    @Override
    public ModelNode execute(ModelNode operation) {
        String command = CliManagementInterface.createCommand(operation);
        CLI.Result result = this.client.cmd(command);
        return result.getResponse();
    }

    private static String createCommand(ModelNode operation) {
        StringBuilder command = new StringBuilder();
        if (operation.has("address")) {
            ModelNode address = operation.get("address");
            for (Object key : address.asList()) {
                Property segment = key.asProperty();
                command.append("/").append(segment.getName()).append("=").append(segment.getValue());
            }
            operation.remove("address");
        }
        if (operation.has("operation")) {
            ModelNode op = operation.get("operation");
            command.append(":").append(op.asString());
            operation.remove("operation");
        }
        if (operation.has("operation-headers")) {
            throw new UnsupportedOperationException("operation-headers are not supported");
        }
        StringBuilder attrs = new StringBuilder();
        Iterator keys = operation.keys().iterator();
        while (keys.hasNext()) {
            Object key;
            key = (String)keys.next();
            ModelNode value = operation.get((String)key);
            if (value.getType() != ModelType.OBJECT) {
                attrs.append((String)key).append("=").append(value.asString());
            }
            if (!keys.hasNext()) continue;
            attrs.append(",");
        }
        command.append("(").append((CharSequence)attrs).append(")");
        return command.toString();
    }

    @Override
    public void close() {
        this.client.disconnect();
    }

    public static ManagementInterface create(String host, int port, String username, String password) {
        CLI client = CLI.newInstance();
        client.connect(host, port, username, password.toCharArray());
        return new CliManagementInterface(client);
    }
}

