/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.rbac;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.rbac.RbacUtil;

public class GroupRolesMappingServerSetupTask
implements ServerSetupTask {
    private final Map<String, Set<String>> rolesToGroups = new HashMap<String, Set<String>>();

    protected GroupRolesMappingServerSetupTask(Map<String, Set<String>> rolesToGroups) {
        this.rolesToGroups.putAll(rolesToGroups);
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.setup(managementClient.getControllerClient());
    }

    public void setup(ModelControllerClient client) throws IOException {
        for (Map.Entry<String, Set<String>> roleEntry : this.rolesToGroups.entrySet()) {
            String role = roleEntry.getKey();
            RbacUtil.addRoleMapping(role, client);
            for (String entity : roleEntry.getValue()) {
                RbacUtil.addRoleGroup(role, entity, client);
            }
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.tearDown(managementClient.getControllerClient());
    }

    public void tearDown(ModelControllerClient client) throws IOException {
        for (Map.Entry<String, Set<String>> roleEntry : this.rolesToGroups.entrySet()) {
            String role = roleEntry.getKey();
            for (String entity : roleEntry.getValue()) {
                RbacUtil.removeRoleGroup(role, entity, client);
            }
            if ("SuperUser".equals(role)) continue;
            RbacUtil.removeRoleMapping(role, client);
        }
    }
}

