/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.rbac;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.rbac.RbacUtil;

public class UserRolesMappingServerSetupTask
implements ServerSetupTask {
    private final Map<String, Set<String>> rolesToUsers = new HashMap<String, Set<String>>();

    protected UserRolesMappingServerSetupTask(Map<String, Set<String>> rolesToUsers) {
        this.rolesToUsers.putAll(rolesToUsers);
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.setup(managementClient.getControllerClient());
    }

    public void setup(ModelControllerClient client) throws IOException {
        for (Map.Entry<String, Set<String>> roleEntry : this.rolesToUsers.entrySet()) {
            String role = roleEntry.getKey();
            RbacUtil.addRoleMapping(role, client);
            for (String user : roleEntry.getValue()) {
                RbacUtil.addRoleUser(role, user, client);
            }
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.tearDown(managementClient.getControllerClient());
    }

    public void tearDown(ModelControllerClient client) throws IOException {
        for (Map.Entry<String, Set<String>> roleEntry : this.rolesToUsers.entrySet()) {
            String role = roleEntry.getKey();
            for (String user : roleEntry.getValue()) {
                RbacUtil.removeRoleUser(role, user, client);
            }
            if ("SuperUser".equals(role)) continue;
            RbacUtil.removeRoleMapping(role, client);
        }
    }

    public static class StandardUsersSetup
    extends UserRolesMappingServerSetupTask {
        private static final Map<String, Set<String>> STANDARD_USERS;
        public static final StandardUsersSetup INSTANCE;

        public StandardUsersSetup() {
            super(STANDARD_USERS);
        }

        static {
            HashMap<String, Set<String>> rolesToUsers = new HashMap<String, Set<String>>();
            rolesToUsers.put("Monitor", Collections.singleton("Monitor"));
            rolesToUsers.put("Operator", Collections.singleton("Operator"));
            rolesToUsers.put("Maintainer", Collections.singleton("Maintainer"));
            rolesToUsers.put("Deployer", Collections.singleton("Deployer"));
            rolesToUsers.put("Administrator", Collections.singleton("Administrator"));
            rolesToUsers.put("Auditor", Collections.singleton("Auditor"));
            rolesToUsers.put("SuperUser", Collections.singleton("SuperUser"));
            STANDARD_USERS = rolesToUsers;
            INSTANCE = new StandardUsersSetup();
        }
    }
}

