/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.test.integration.management.util.CLIOpResult;
import org.jboss.as.test.integration.management.util.CLITestUtil;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class CLIWrapper {
    private final CommandContext ctx;
    private ByteArrayOutputStream consoleOut = new ByteArrayOutputStream();

    public CLIWrapper() throws Exception {
        this(false);
    }

    public CLIWrapper(boolean connect) throws Exception {
        this(connect, null);
    }

    public CLIWrapper(boolean connect, String cliAddress) throws CliInitializationException {
        this(connect, cliAddress, null);
    }

    public CLIWrapper(boolean connect, String cliAddress, InputStream consoleInput) throws CliInitializationException {
        System.setProperty("aesh.terminal", "org.jboss.aesh.terminal.TestTerminal");
        this.ctx = CLITestUtil.getCommandContext(TestSuiteEnvironment.getServerAddress(), TestSuiteEnvironment.getServerPort(), consoleInput, this.consoleOut);
        if (!connect) {
            return;
        }
        Assert.assertTrue((boolean)this.sendConnect(cliAddress));
    }

    public boolean isConnected() {
        return this.ctx.getModelControllerClient() != null;
    }

    public boolean sendConnect() {
        return this.sendConnect(null);
    }

    public final boolean sendConnect(String cliAddress) {
        String addr = cliAddress != null ? cliAddress : TestSuiteEnvironment.getServerAddress();
        try {
            this.ctx.connectController(new URI("http-remoting", null, addr, TestSuiteEnvironment.getServerPort(), null, null, null).toString());
            return true;
        }
        catch (CommandLineException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendLine(String line, boolean ignoreError) {
        this.consoleOut.reset();
        if (ignoreError) {
            this.ctx.handleSafe(line);
            return this.ctx.getExitCode() == 0;
        }
        try {
            this.ctx.handle(line);
        }
        catch (CommandLineException e) {
            Assert.fail((String)("Failed to execute line '" + line + "': " + e.getLocalizedMessage()));
        }
        return true;
    }

    public void sendLine(String line) {
        this.sendLine(line, false);
    }

    public String readOutput() {
        if (this.consoleOut.size() <= 0) {
            return null;
        }
        return new String(this.consoleOut.toByteArray());
    }

    public CLIOpResult readAllAsOpResult() throws IOException {
        String response = this.readOutput();
        if (response == null) {
            return new CLIOpResult();
        }
        ModelNode node = ModelNode.fromString((String)response);
        return new CLIOpResult(node);
    }

    public synchronized void quit() {
        this.ctx.terminateSession();
    }

    public boolean hasQuit() {
        return this.ctx.isTerminated();
    }

    protected String getUsername() {
        return "testSuite";
    }

    protected String getPassword() {
        return "testSuitePassword";
    }
}

