/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config.realm;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class TrustAndStoreTrustManager
implements X509TrustManager {
    private static final X509Certificate[] EMPTY_ACCEPTED_ISSUERS = new X509Certificate[0];
    private static final List<X509Certificate> CLIENT_CERTS_LIST = Collections.synchronizedList(new ArrayList());

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null && chain.length > 0) {
            if (CLIENT_CERTS_LIST.size() > 50) {
                CLIENT_CERTS_LIST.clear();
            }
            Collections.addAll(CLIENT_CERTS_LIST, chain);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_ACCEPTED_ISSUERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSubjectInClientCertChain(String rfc2253Name) {
        if (rfc2253Name != null) {
            List<X509Certificate> list = CLIENT_CERTS_LIST;
            synchronized (list) {
                for (X509Certificate cert : CLIENT_CERTS_LIST) {
                    if (!rfc2253Name.equals(cert.getSubjectX500Principal().getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

