/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.controller.client.ModelControllerClient;

public class TestSuiteEnvironment {
    public static ModelControllerClient getModelControllerClient() {
        try {
            return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(TestSuiteEnvironment.getServerAddress()), (int)TestSuiteEnvironment.getServerPort(), (CallbackHandler)Authentication.getCallbackHandler());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJavaPath() {
        String home = System.getenv("JAVA_HOME");
        if (home == null) {
            home = TestSuiteEnvironment.getSystemProperty("java.home");
        }
        if (home != null) {
            return home + File.separator + "bin" + File.separator + "java";
        }
        return "java";
    }

    public static String getSystemProperty(String name, String def) {
        return System.getProperty(name, def);
    }

    public static String getSystemProperty(String name) {
        return System.getProperty(name);
    }

    public static String getTmpDir() {
        return TestSuiteEnvironment.getSystemProperty("java.io.tmpdir");
    }

    public static int getServerPort() {
        return Integer.getInteger("as.managementPort", 9990);
    }

    public static String getServerAddress() {
        return TestSuiteEnvironment.formatPossibleIpv6Address(System.getProperty("node0", "localhost"));
    }

    public static String getIpv6Args() {
        if (System.getProperty("ipv6") == null) {
            return " -Djava.net.preferIPv4Stack=true -Djava.net.preferIPv6Addresses=false ";
        }
        return " -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true ";
    }

    public static void getIpv6Args(List<String> command) {
        if (System.getProperty("ipv6") == null) {
            command.add("-Djava.net.preferIPv4Stack=true");
            command.add("-Djava.net.preferIPv6Addresses=false");
        } else {
            command.add("-Djava.net.preferIPv4Stack=false");
            command.add("-Djava.net.preferIPv6Addresses=true");
        }
    }

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    public static String getSecondaryTestAddress(boolean useCannonicalHost) {
        String address = System.getProperty("secondary.test.address");
        if (StringUtils.isBlank((String)address)) {
            address = TestSuiteEnvironment.getServerAddress();
        }
        if (useCannonicalHost) {
            address = StringUtils.strip((String)address, (String)"[]");
        }
        return address;
    }
}

