/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.auditlog;

import java.util.List;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.logging.syslogserver.BlockedSyslogServerEventHandler;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.productivity.java.syslog4j.server.SyslogServer;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;

public abstract class AuditLogToSyslogSetup
implements ServerSetupTask {
    private static final String SYSLOG_HANDLER_NAME = "audit-test-syslog-handler";
    private static final String SYSLOG_HANDLER_NAME2 = "audit-test-syslog-handler2";
    private static final int SYSLOG_PORT = 9176;
    private static final PathAddress AUDIT_LOG_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("core-service", "management").append("access", "audit");
    public static final PathAddress AUDIT_LOG_LOGGER_ADDR = AUDIT_LOG_ADDRESS.append("logger", "audit-log");
    private static final PathAddress AUDIT_SYSLOG_HANDLER_ADDR = AUDIT_LOG_ADDRESS.append("syslog-handler", "audit-test-syslog-handler");
    static final PathAddress AUDIT_SYSLOG_HANDLER_ADDR2 = AUDIT_LOG_ADDRESS.append("syslog-handler", "audit-test-syslog-handler2");
    static final PathAddress AUDIT_LOG_LOGGER_SYSLOG_HANDLER_ADDR = AUDIT_LOG_LOGGER_ADDR.append("handler", "audit-test-syslog-handler");
    static final PathAddress AUDIT_LOG_LOGGER_SYSLOG_HANDLER_ADDR2 = AUDIT_LOG_LOGGER_ADDR.append("handler", "audit-test-syslog-handler2");
    private SyslogServerIF server;
    private static final String FORMATTER = "formatter";
    private static final String JSON_FORMATTER = "json-formatter";
    static final String DEFAULT_APPNAME = "WildFly";

    protected abstract String getSyslogProtocol();

    protected abstract SyslogServerConfigIF getSyslogConfig();

    protected abstract ModelNode addAuditlogSyslogProtocol(PathAddress var1);

    protected List<ModelNode> addProtocolSettings(PathAddress syslogHandlerAddress) {
        return null;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        SyslogServer.shutdown();
        String host = Utils.getHost(managementClient);
        SyslogServerConfigIF config = this.getSyslogConfig();
        config.setUseStructuredData(true);
        config.setHost(host);
        config.setPort(9176);
        config.addEventHandler((SyslogServerEventHandlerIF)new BlockedSyslogServerEventHandler());
        String syslogProtocol = this.getSyslogProtocol();
        this.server = SyslogServer.createInstance((String)syslogProtocol, (SyslogServerConfigIF)config);
        SyslogServer.getThreadedInstance((String)syslogProtocol);
        this.addSyslogHandler(managementClient, AUDIT_SYSLOG_HANDLER_ADDR, host, null, null);
        this.addSyslogHandler(managementClient, AUDIT_SYSLOG_HANDLER_ADDR2, host, "TestApp", SyslogAuditLogHandler.Facility.LINE_PRINTER);
        ModelNode op = Util.createAddOperation((PathAddress)AUDIT_LOG_LOGGER_SYSLOG_HANDLER_ADDR);
        CoreUtils.applyUpdate((ModelNode)op, (ModelControllerClient)managementClient.getControllerClient());
        op = Util.getWriteAttributeOperation((PathAddress)AUDIT_LOG_LOGGER_ADDR, (String)"log-read-only", (boolean)false);
        CoreUtils.applyUpdate((ModelNode)op, (ModelControllerClient)managementClient.getControllerClient());
    }

    private void addSyslogHandler(ManagementClient managementClient, PathAddress syslogHandlerAddress, String host, String appName, SyslogAuditLogHandler.Facility facility) throws Exception {
        ModelNode op = this.createSyslogHandlerAddComposite(syslogHandlerAddress, host, appName, facility);
        CoreUtils.applyUpdate((ModelNode)op, (ModelControllerClient)managementClient.getControllerClient());
        List<ModelNode> protocolSettings = this.addProtocolSettings(syslogHandlerAddress);
        if (protocolSettings != null) {
            CoreUtils.applyUpdates(protocolSettings, (ModelControllerClient)managementClient.getControllerClient());
        }
    }

    private ModelNode createSyslogHandlerAddComposite(PathAddress syslogHandlerAddress, String host, String appName, SyslogAuditLogHandler.Facility facility) {
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        ModelNode op = Util.createAddOperation((PathAddress)syslogHandlerAddress);
        op.get(FORMATTER).set(JSON_FORMATTER);
        op.get("syslog-format").set("RFC5424");
        if (appName != null) {
            op.get("app-name").set(appName);
        }
        if (facility != null) {
            op.get("facility").set(facility.toString());
        }
        steps.add(op);
        ModelNode auditlogSyslogProtocol = this.addAuditlogSyslogProtocol(syslogHandlerAddress);
        auditlogSyslogProtocol.get("port").set(9176);
        auditlogSyslogProtocol.get("host").set(host);
        steps.add(auditlogSyslogProtocol);
        return compositeOp;
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        SyslogServer.shutdown();
        this.server.setThread(null);
        this.server.getConfig().removeAllEventHandlers();
        this.removeResource(managementClient, AUDIT_LOG_LOGGER_SYSLOG_HANDLER_ADDR);
        this.removeResource(managementClient, AUDIT_LOG_LOGGER_SYSLOG_HANDLER_ADDR2);
        this.removeResource(managementClient, AUDIT_SYSLOG_HANDLER_ADDR2);
        this.removeResource(managementClient, AUDIT_SYSLOG_HANDLER_ADDR);
        CoreUtils.applyUpdate((ModelNode)Util.getWriteAttributeOperation((PathAddress)AUDIT_LOG_LOGGER_ADDR, (String)"log-read-only", (boolean)false), (ModelControllerClient)managementClient.getControllerClient());
    }

    private void removeResource(ManagementClient managementClient, PathAddress address) throws Exception {
        PathElement element = address.getLastElement();
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        ModelNode op = Util.createOperation((String)"read-children-names", (PathAddress)parentAddress);
        op.get("child-type").set(element.getKey());
        ModelNode result = managementClient.getControllerClient().execute(op);
        if (result.hasDefined("result") && result.get("result").asList().contains(new ModelNode(element.getValue()))) {
            op = Util.createRemoveOperation((PathAddress)address);
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            CoreUtils.applyUpdate((ModelNode)op, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

